% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert2ggplot.r
\name{convert2ggplot}
\alias{convert2ggplot}
\title{Convert RRPP plots to ggplot objects}
\usage{
convert2ggplot(object)
}
\arguments{
\item{object}{A plot object produced from \code{\link{plot.lm.rrpp}} and type 
equals either "PC" or "regression, \code{\link{plot.predict.lm.rrpp}}, or 
\code{\link{plot.ordinate}}.  Essentially, any RRPP plot except a series of diagnostic
plots should work.}
}
\description{
Function attempts to coerce plot information from an RRPP plot object to an 
amenable ggplot object.
}
\details{
This function will attempt to use the plot arguments from an RRPP plot object 
to make a ggplot that can be additionally updated, as desired.  Not all plot 
characteristics can be converted.  For example, text arguments are not currently
passed to \code{\link{ggplot}}, as the \code{\link{text}} function and geom_text
arguments do not easily align.  However, one can use text arguments produced by
a RRPP plot object and geom_text to augment a ggplot object the way they like.

This function assumes no responsibility for arguments made by \code{\link{ggplot}}.
It merely produces a ggplot object that should resemble an RRPP plot default.  Any 
augmentation of ggplot objects can be done either by direct intervention of the ggplot 
produced or reformatting the initial RRPP plot produced.  One should not expect direct
correspondence between R base plot parameters and ggplot parameters.  For example,
error bars will generally appear as different widths, without an easy way to control them,
changing from one format to the other.
}
\examples{
\dontrun{
### Linear Model Example

data(Pupfish)
fit <- lm.rrpp(coords ~ log(CS) + Sex*Pop, SS.type = "I", 
data = Pupfish, print.progress = FALSE) 

# Predictions (holding alternative effects constant)

shapeDF <- expand.grid(Sex = levels(Pupfish$Sex), 
Pop = levels(Pupfish$Pop))
rownames(shapeDF) <- paste(shapeDF$Sex, shapeDF$Pop, sep = ".")

shapePreds <- predict(fit, shapeDF)
summary(shapePreds, PC = TRUE)

# Plot prediction

P <- plot(shapePreds, PC = TRUE, ellipse = TRUE)
convert2ggplot(P)

### Ordination Example

data("PlethMorph")

Y <- as.data.frame(PlethMorph[c("TailLength", "HeadLength", 
                               "Snout.eye", "BodyWidth", 
                               "Forelimb", "Hindlimb")])
Y <- as.matrix(Y)
R <- lm.rrpp(Y ~ SVL, data = PlethMorph, 
             print.progress = FALSE)$LM$residuals

# PCA (on correlation matrix)


PCA.ols <- ordinate(R, scale. = TRUE)
PCA.ols$rot
prcomp(R, scale. = TRUE)$rotation # should be the same


PCA.gls <- ordinate(R, scale. = TRUE, 
                   transform. = FALSE, 
                   Cov = PlethMorph$PhyCov)
               
P <- plot(PCA.gls)
convert2ggplot(P)                   
}
}
\author{
Michael Collyer
}
\keyword{utilities}
