% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbplyr-db.R, R/dbplyr-src.R
\name{db_desc.PrestoConnection}
\alias{db_desc.PrestoConnection}
\alias{db_data_type.PrestoConnection}
\alias{db_explain.PrestoConnection}
\alias{db_query_rows.PrestoConnection}
\alias{db_collect.PrestoConnection}
\alias{collect.tbl_presto}
\alias{compute.tbl_presto}
\title{S3 implementation of \code{db_desc} for Presto.}
\usage{
\method{db_desc}{PrestoConnection}(x)

\method{db_data_type}{PrestoConnection}(con, fields, ...)

\method{db_explain}{PrestoConnection}(con, sql, ...)

\method{db_query_rows}{PrestoConnection}(con, sql)

\method{db_collect}{PrestoConnection}(con, sql, n = -1, warn_incomplete = TRUE, ...)

\method{collect}{tbl_presto}(x, ..., n = Inf, warn_incomplete = TRUE)

\method{compute}{tbl_presto}(x, name, temporary = FALSE, ..., cte = FALSE)
}
\arguments{
\item{x}{A lazy data frame backed by a database query.}

\item{cte}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
An experimental feature to save the query to a common table expression.
Default to FALSE. See \code{vignette("common-table-expressions")}}
}
\description{
S3 implementation of \code{db_desc} for Presto.

S3 implementation of \code{\link[dplyr:backend_dbplyr]{dplyr::db_data_type()}} for Presto.

S3 implementation of \code{\link[dplyr:backend_dbplyr]{dplyr::db_explain()}} for Presto.

S3 implementation of \code{\link[dplyr:backend_dbplyr]{dplyr::db_query_rows()}} for Presto.

S3 implementation of \code{db_collect} for Presto.

S3 implementation of \code{collect} for Presto.

S3 implementation of \code{compute} for Presto.
}
\keyword{internal}
