% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quote.R
\name{quote}
\alias{quote}
\alias{dbQuoteString,PqConnection,character-method}
\alias{dbQuoteString,PqConnection,SQL-method}
\alias{dbQuoteIdentifier,PqConnection,character-method}
\alias{dbQuoteIdentifier,PqConnection,SQL-method}
\alias{dbQuoteIdentifier,PqConnection,Id-method}
\alias{dbUnquoteIdentifier,PqConnection,SQL-method}
\alias{dbQuoteLiteral,PqConnection-method}
\title{Quote postgres strings, identifiers, and literals}
\usage{
\S4method{dbQuoteString}{PqConnection,character}(conn, x, ...)

\S4method{dbQuoteString}{PqConnection,SQL}(conn, x, ...)

\S4method{dbQuoteIdentifier}{PqConnection,character}(conn, x, ...)

\S4method{dbQuoteIdentifier}{PqConnection,SQL}(conn, x, ...)

\S4method{dbQuoteIdentifier}{PqConnection,Id}(conn, x, ...)

\S4method{dbUnquoteIdentifier}{PqConnection,SQL}(conn, x, ...)

\S4method{dbQuoteLiteral}{PqConnection}(conn, x, ...)
}
\arguments{
\item{conn}{A \linkS4class{PqConnection} created by \code{dbConnect()}}

\item{x}{A character vector to be quoted.}

\item{...}{Other arguments needed for compatibility with generic (currently
ignored).}
}
\description{
If an object of class \link{Id} is used for \code{dbQuoteIdentifier()}, it needs
at most one \code{table} component and at most one \code{schema} component.
}
\examples{
\dontshow{if (postgresHasDefault()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(DBI)
con <- dbConnect(RPostgres::Postgres())

x <- c("a", "b c", "d'e", "\\\\f")
dbQuoteString(con, x)
dbQuoteIdentifier(con, x)
dbDisconnect(con)
\dontshow{\}) # examplesIf}
}
