% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PqConnection.R
\name{postgresWaitForNotify}
\alias{postgresWaitForNotify}
\title{Wait for and return any notifications that return within timeout}
\usage{
postgresWaitForNotify(conn, timeout = 1)
}
\arguments{
\item{conn}{a \linkS4class{PqConnection} object, produced by
\code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{timeout}{How long to wait, in seconds. Default 1}
}
\value{
If a notification was available, a list of:
\describe{
\item{channel}{Name of channel}
\item{pid}{PID of notifying server process}
\item{payload}{Content of notification}
}
If no notifications are available, return NULL
}
\description{
Once you subscribe to notifications with LISTEN, use this to wait for
responses on each channel.
}
\examples{
\dontshow{if (postgresHasDefault()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(DBI)
library(callr)

# listen for messages on the grapevine
db_listen <- dbConnect(RPostgres::Postgres())
dbExecute(db_listen, "LISTEN grapevine")

# Start another process, which sends a message after a delay
rp <- r_bg(function () {
    library(DBI)
    Sys.sleep(0.3)
    db_notify <- dbConnect(RPostgres::Postgres())
    dbExecute(db_notify, "NOTIFY grapevine, 'psst'")
    dbDisconnect(db_notify)
})

# Sleep until we get the message
n <- NULL
while (is.null(n)) {
    n <- RPostgres::postgresWaitForNotify(db_listen, 60)
}
stopifnot(n$payload == 'psst')

# Tidy up
rp$wait()
dbDisconnect(db_listen)
\dontshow{\}) # examplesIf}
}
