% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopcuts.R
\name{loopcuts}
\alias{loopcuts}
\title{Change-point p-values with backward elimination}
\usage{
loopcuts(time,censor,cuttimes,mono)
}
\arguments{
\item{time}{a sequence of time}

\item{censor}{a vector indicating censored or not at the given times, 0 = censored; 1 = uncensored}

\item{cuttimes}{unique, sorted, possible times to make the cuts, including 0 and the ending time}

\item{mono}{0: 2-sided hypothesis: H0: lam1 is equal to lam2; H1: lam1 is not equal to lam2
1: 1-sided hypothesis: H0: lam1 is greater than or equal to lam2; H1: lam1 is less than lam2
2: 1-sided hypothesis: H0: lam1 is less than or equal to lam2; H1: lam1 is greater than lam2}
}
\value{
the times in the backward elimination procedure and the corresponding p-values for each change-point in the iteration
}
\description{
A function that iterates to compute the p-values from the backward elimination procedure (Han et al. 2014)
}
\examples{
data(loopcuts_t_c)
data(loopcuts_cut)
time = loopcuts_t_c[,1]
censor = loopcuts_t_c[,2]
loopcuts(time, censor, loopcuts_cut, 1)
}
