% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printGainsTable.R
\name{print.gainstable}
\alias{print.gainstable}
\title{Print \code{'gainstable'} Object}
\usage{
\method{print}{gainstable}(x, maxdigit = 3, ... = NULL)
}
\arguments{
\item{x}{An object of class \code{"gainstable"}, created with either
\code{\link{gainstable.default}} or \code{\link{gainstable.rocit}}.}

\item{maxdigit}{How many digits after decimal to be printed.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\description{
S3 print method to print \code{"gainstable"} object.
}
\examples{
data("Loan")
class <- Loan$Status
score <- Loan$Score
rocit_emp <- rocit(score = score, class = class, negref = "FP")
# ----------------------------------------------------------------
gtable8 <- gainstable(rocit_emp, ngroup = 8)
print(gtable8)
print(gtable8, maxdigit = 4)
}
