% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocCIbin.R
\name{ciROCbin}
\alias{ciROCbin}
\title{Confidence Interval of Binormal ROC Curve}
\usage{
ciROCbin(rocit_bin, level, nboot)
}
\arguments{
\item{rocit_bin}{An object of class \code{rocit}, (\code{method = "binormal"}).}

\item{level}{Desired level of confidence to be estimated.}

\item{nboot}{Number of bootstrap samples, used to estimate \code{var(A)},
\code{var(B)}, \code{cov(A,B)}. See \code{\link{ciROC.rocit}}.}
}
\value{
A list object containing TPR, upper and lower bound of TPR
at certain FPR values.
}
\description{
Function \code{ciROCbin} estimates confidence interval
of binormally estimated ROC curve.
}
\section{Comment}{

\code{ciROCbin} is used internally in \code{\link{ciROC.rocit}}
of \pkg{ROCit}.
}

\examples{
data("Loan")
score <- Loan$Score
class <- ifelse(Loan$Status == "CO", 1, 0)
rocit_bin <- rocit(score = score, class = class, method = "bin")
ciROC_bin90 <- ciROCbin(rocit_bin, level = 0.9, nboot = 300)
TPR <- ciROC_bin90$TPR
FPR <- ciROC_bin90$FPR
Upper90 <- ciROC_bin90$UpperTPR
Lower90 <- ciROC_bin90$LowerTPR
plot(TPR~FPR, type = "l")
lines(Upper90~FPR, lty = 2)
lines(Lower90~FPR, lty = 2)
grid()
legend("bottomright", c("Binormal ROC curve", "90\% CI"), lty = c(1,2))

}
\seealso{
\code{\link{rocit}}, \code{\link{ciROC}}, \code{\link{plot.rocci}}
}
