% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trap_MLestimates.R
\name{MLestimates}
\alias{MLestimates}
\title{ML Estimate of Normal Parameters}
\usage{
MLestimates(x)
}
\arguments{
\item{x}{A numeric vector.}
}
\value{
A \code{"list"} object of two numeric components,
\eqn{\mu} and \eqn{\sigma}.
}
\description{
The function calculates the maximum likelihood (ML) estimates
of the two parameters \eqn{\mu} and \eqn{\sigma}, when a set of numbers are
assumed to be normally distributed.
}
\details{
If a set of observations
are assumed to be normally
distributed, two parameters, mean \eqn{\mu} and the variance (the square
of \eqn{\sigma})
are to be estimated. In theory, the ML estimate of \eqn{\mu} is the mean of the
observations. And the ML estimate of square of \eqn{\sigma} is the mean
squared deviation of the observations from the estimated \eqn{\mu}.
}
\section{Comment}{

\code{MLestimates} is used internally in other function(s) of \pkg{ROCit}.
}

\examples{
# Find the two parameters
set.seed(10)
points <- rnorm(200, 10, 5)
ML <- MLestimates(points)
message("The ML estimates are: mean = ", round(ML$mu, 3),
        " , SD = ", round(ML$sigma, 3))

#-----------------------------------------

# Superimpose smooth curve over hostogram
set.seed(100)
x <- rnorm(400)
hist(x, probability = TRUE, col = "gray90")
ML <- MLestimates(x)
x <- seq(-3, 3, 0.01)
density <- dnorm(x, mean = ML$mu, sd = ML$sigma)
lines(density~x, lwd = 2)

}
