% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_documents.r
\name{compare_documents}
\alias{compare_documents}
\title{Compare the documents in a dtm}
\usage{
compare_documents(
  dtm,
  dtm_y = NULL,
  date_var = NULL,
  hour_window = c(-24, 24),
  group_var = NULL,
  measure = c("cosine", "overlap_pct", "overlap", "dot_product", "softcosine"),
  tf_idf = F,
  min_similarity = 0,
  n_topsim = NULL,
  only_complete_window = T,
  copy_meta = T,
  backbone_p = 1,
  simmat = NULL,
  simmat_thres = NULL,
  batchsize = 1000,
  verbose = FALSE
)
}
\arguments{
\item{dtm}{A quanteda \link[quanteda]{dfm}. Note that it is common to first weight the dtm(s) before calculating document similarity,
For this you can use quanteda's \link[quanteda]{dfm_tfidf} and \link[quanteda]{dfm_weight}}

\item{dtm_y}{Optionally, another dtm. If given, the documents in dtm will be compared to the documents in dtm_y.}

\item{date_var}{Optionally, the name of the column in docvars that specifies the document date. The values should be of type POSIXct, or coercable with as.POSIXct.
If given, the hour_window argument is used to only compare documents within a time window.}

\item{hour_window}{A vector of length 2, in which the first and second value determine the left and right side of the window, respectively. 
For example, c(-10, 36) will compare each document to all documents between the previous 10 and the next 36 hours.
It is possible to specify time windows down to the level of seconds by using fractions (hours / 60 / 60).}

\item{group_var}{Optionally,  The name of the column in docvars that specifies a group (e.g., source, sourcetype). If given, only documents within the same group will be compared.}

\item{measure}{The measure that should be used to calculate similarity/distance/adjacency. Currently supports the symmetrical measure "cosine" (cosine similarity), the assymetrical measures "overlap_pct" (percentage of term scores in the document 
that also occur in the other document), "overlap" (like overlap_pct, but as the sum of overlap instead of the percentage) and the symmetrical soft cosine measure (experimental).
The regular dot product (dot_product) is also supported.}

\item{tf_idf}{If TRUE, weigh the dtm (and dtm_y) by term frequency - inverse document frequency. For more control over weighting,
we recommend using quanteda's \link[quanteda]{dfm_tfidf} or \link[quanteda]{dfm_weight} on dtm and dtm_y.}

\item{min_similarity}{A threshold for similarity. lower values are deleted. For all available similarity measures zero means no similarity.}

\item{n_topsim}{An alternative or additional sort of threshold for similarity. Only keep the [n_topsim] highest similarity scores for x. Can return more than [n_topsim] similarity scores in the case of duplicate similarities.}

\item{only_complete_window}{If True, only compare articles (x) of which a full window of reference articles (y) is available. Thus, for the first and last [window.size] days, there will be no results for x.}

\item{copy_meta}{If TRUE, copy the dtm docvars to the from_meta and to_meta data.tables}

\item{backbone_p}{Apply backbone filtering with a "disparity" filter (see \href{https://www.pnas.org/content/106/16/6483.full}{Serrano et al.}).
It is different from the original disparity filter algorithm in that it only looks at outward edges. Also, the outward degree k is
measured as all possible edges (within a window), not just the non-zero edges.}

\item{simmat}{If softcosine is used, a symmetrical matrix with the similarity scores of terms. If NULL, the cosine similarity of terms in dtm will be used}

\item{simmat_thres}{A large, dense simmat can lead to memory problems and slows down computation. A pragmatig (though not mathematically pure) solution is to use a threshold to prune small similarities.}

\item{batchsize}{For internal use (testing)}

\item{verbose}{If TRUE, report progress}
}
\value{
A S3 class for RNewsflow_edgelist, which is a list with the edgelist, from_meta and to_meta data.tables.
}
\description{
This function calculates document similarity scores using a vector space approach. The most important
benefit is that it includes options for limiting the number of comparisons that need to be made and filtering
the results, that are efficiently implemented in a custom inner product calculation. This makes it possible 
to compare a huge number of documents, especially for cases where only documents witihin a given time window need
to be compared.
}
\details{
By default, the function performs a regular tcrossprod of the dtm (with itself or with dtm_y). The following parameters can be
set to limit comparisons and filter output:
\itemize{
   \item{If the 'date_var' is specified. The given hour_window is used to only compare documents within the specified time distance.}
   \item{If the 'group_var' is specified, only documents for which the group is identical will be compared.}
   \item{With the 'min_similarity' argument, the output can be filtered with a minimum similarity threshold. For the inner product of two
         DTMs the size of the output matrix is often the main bottleneck for comparing many documents, because it generally increases exponentially with
         the number of documents in the DTMs. Even a low similarity threshold can greatly reduce the size of the output}
   \item{As an alternative or additional filter, you can limit the results for each row in dtm to the highest top_n similarity scores}
}
 
Margin attributes are also included in the output in the from_meta and to_meta data.tables (see details).
If copy_meta = TRUE, The dtm docvars are also included in from_meta and to_meta.


Margin attributes are added to the meta data.
The reason for including this is that some values that are normally available in a similarity matrix are missing if certain filter options are used.
If group or date is used, we don't know how many columns a rows has been compared to (normally this is all columns).
If a min/max or top_n filter is used, we don't know the true row sums (and thus row means).
The meta data therefore includes the "row_n", "row_sum", "col_n", and "col_sum".
In addition, there are "lag_n" and "lag_sum". this is a special case where row_n and row_sum are calculated for only matches where the column date < row date (lag).
This can be used for more refined calculations of edge probabilities before and after a row document.
}
\examples{
dtm = quanteda::dfm_tfidf(rnewsflow_dfm)
el = compare_documents(dtm, date_var='date', hour_window = c(0.1, 36))


d = data.frame(text = c('a b c d e', 
                        'e f g h i j k',
                        'a b c'),
               date = as.POSIXct(c('2010-01-01','2010-01-01','2012-01-01')), 
               stringsAsFactors=FALSE)
corp = quanteda::corpus(d, text_field='text')
dtm = quanteda::dfm(corp)

g = compare_documents(dtm)
g

g = compare_documents(dtm, measure = 'overlap_pct')
g
}
