% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.r
\name{document.network}
\alias{document.network}
\title{Create a document similarity network}
\usage{
document.network(d, meta, id.var = "document_id", date.var = "date",
  min.similarity = 0)
}
\arguments{
\item{d}{A data.frame with three columns, that represents an edgelist with weight values. 
The first and second column represent the names/ids of the 'from' and 'to' documents/vertices. 
The third column represents the similarity score. Column names are ignored}

\item{meta}{A data.frame where rows are documents and columns are document meta information. 
Should at least contain 2 columns: the document name/id and date. 
The name/id column should match the document names/ids of the edgelist, and its label is specified in the `id.var` argument. 
The date column should be intepretable with \link[base]{as.POSIXct}, and its label is specified in the `date.var` argument.}

\item{id.var}{The label for the document name/id column in the `meta` data.frame. Default is "document_id"}

\item{date.var}{The label for the document date column in the `meta` data.frame . default is "date"}

\item{min.similarity}{For convenience, ignore all edges where the weight is below `min.similarity`. Default is zero.}
}
\value{
A network/graph in the \link[igraph]{igraph} class
}
\description{
Combines document similarity data (d) with document meta data (meta) into an \link[igraph]{igraph} network/graph.
}
\details{
This function is mainly offered to mimic the output of the \link[RNewsflow]{newsflow.compare} function when using imported document similarity data.
This way the functions for transforming, aggregating and visualizing the document similarity data can be used.
}
\examples{
d = data.frame(x = c(1,1,1,2,2,3),
               y = c(2,3,5,4,5,6),
               v = c(0.3,0.4,0.7,0.5,0.2,0.9))

meta = data.frame(document_id = 1:8,
                  date = seq.POSIXt(from = as.POSIXct('2010-01-01 12:00:00'), 
                         by='hour', length.out = 8),
                  medium = c(rep('Newspapers', 4), rep('Blog', 4)))

g = document.network(d, meta)

igraph::get.data.frame(g, 'both')
igraph::plot.igraph(g)
}

