% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getLabeledNodes.R
\name{getLabeledNodes}
\alias{getLabeledNodes}
\title{Retrieve Nodes by Label and Property}
\usage{
getLabeledNodes(graph, .label, ...)
}
\arguments{
\item{graph}{A graph object.}

\item{.label}{A character string.}

\item{...}{A named list. A key = value pair to search the labeled nodes.}
}
\value{
A list of node objects.
}
\description{
Retrieve nodes from the graph with the specified label and optional key = value pair.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

createNode(graph, "School", name = "University of Texas at Austin")
createNode(graph, "School", name = "Louisiana State University")

createNode(graph, "Person", name = "Nicole", status = "Employed")
createNode(graph, "Person", name = "Drew", status = "Employed")
createNode(graph, "Person", name = "Aaron", status = "Unemployed")

schools = getLabeledNodes(graph, "School")

sapply(schools, function(s) s$name)

employed_people = getLabeledNodes(graph, "Person", status = "Employed")

sapply(employed_people, function(p) p$name)
}
}
\seealso{
\code{\link{getUniqueNode}}
}

