% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/driver.R
\docType{class}
\name{MySQLDriver-class}
\alias{MySQL}
\alias{MySQLDriver-class}
\alias{RMySQL}
\alias{RMySQL-package}
\title{Class MySQLDriver with constructor MySQL.}
\usage{
MySQL(max.con = 16, fetch.default.rec = 500)
}
\arguments{
\item{max.con}{maximum number of connections that can be open
at one time. There's no intrinic limit, since strictly speaking this limit
applies to MySQL \emph{servers}, but clients can have (at least in theory)
more than this.  Typically there are at most a handful of open connections,
thus the internal \code{RMySQL} code uses a very simple linear search
algorithm to manage its connection table.}

\item{fetch.default.rec}{number of records to fetch at one time from the
database. (The \code{\link[DBI]{fetch}} method uses this number as a
default.)}
}
\description{
An MySQL driver implementing the R database (DBI) API.
This class should always be initialized with the \code{MySQL()} function.
It returns a singleton that allows you to connect to MySQL.
}
\examples{
if (mysqlHasDefault()) {
# connect to a database and load some data
con <- dbConnect(RMySQL::MySQL(), dbname = "test")
dbWriteTable(con, "USArrests", datasets::USArrests, overwrite = TRUE)

# query
rs <- dbSendQuery(con, "SELECT * FROM USArrests")
d1 <- dbFetch(rs, n = 10)      # extract data in chunks of 10 rows
dbHasCompleted(rs)
d2 <- dbFetch(rs, n = -1)      # extract all remaining data
dbHasCompleted(rs)
dbClearResult(rs)
dbListTables(con)

# clean up
dbRemoveTable(con, "USArrests")
dbDisconnect(con)
}
}

