% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_indexed_copy}
\alias{mvl_indexed_copy}
\title{Index copy vector}
\usage{
mvl_indexed_copy(MVLHANDLE, x, indices, name = NULL, only.columns = NULL)
}
\arguments{
\item{MVLHANDLE}{a handle to MVL file produced by mvl_open()}

\item{x}{a suitable R object (vector, array, list, data.frame) or a vector-like MVL_OBJECT}

\item{indices}{list of indices into x}

\item{name}{if specified add a named entry to MVL file directory}

\item{only.columns}{if x is MVL_OBJECT with class data.frame copy only columns specified in this character or integer vector}
}
\value{
an object of class MVL_OFFSET that describes an offset into this MVL file. MVL offsets are vectors and can be concatenated. They can be written to MVL file directly, or as part of another object such as list.
}
\description{
Index copy vector
}
\examples{
\dontrun{
Mtmp<-mvl_open("tmp_a.mvl", append=TRUE, create=TRUE)
mvl_write_object(Mtmp, runif(100), "vec1")
Mtmp<-mvl_remap(Mtmp)
permutation1<-mvl_order_vectors(list(Mtmp["vec1", ref=TRUE]))
mvl_indexed_copy(Mtmp, Mtmp["vec1", ref=TRUE], permutation1, name="vec1_sorted")
Mtmp<-mvl_remap(Mtmp)
print(Mtmp$vec1_sorted)
}
}
\seealso{
\code{\link{mvl_hash_vectors}}, \code{\link{mvl_find_matches}}, \code{\link{mvl_group}}, \code{\link{mvl_find_matches}}, \code{\link{mvl_order_vectors}}, \code{\link{mvl_merge}}, \code{\link{mvl_write_object}}, \code{\link{mvl_fused_write_objects}}
}
