% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTL.R
\name{MTL}
\alias{MTL}
\title{Train a multi-task learning model.}
\usage{
MTL(X, Y, type = "Classification", Regularization = "L21",
  Lam1 = 0.1, Lam1_seq = NULL, Lam2 = 0, opts = list(init = 0, tol
  = 10^-3, maxIter = 1000), G = NULL, k = 2)
}
\arguments{
\item{X}{A set of feature matrices}

\item{Y}{A set of responses, could be binary (classification
problem) or continues (regression problem). The valid
value of binary outcome \eqn{\in\{1, -1\}}}

\item{type}{The type of problem, must be \code{Regression} or
\code{Classification}}

\item{Regularization}{The type of MTL algorithm (cross-task regularizer). The value must be
one of \{\code{L21}, \code{Lasso}, \code{Trace}, \code{Graph}, \code{CMTL} \}}

\item{Lam1}{A positive constant \eqn{\lambda_{1}} to control the
cross-task regularization}

\item{Lam1_seq}{A positive sequence of \code{Lam1}. If the parameter
is given, the model is trained using warm-start technique. Otherwise, the
model is trained based on the \code{Lam1} and the initial search point (\code{opts$init}).}

\item{Lam2}{A non-negative constant \eqn{\lambda_{2}} to improve the
generalization performance with the default value of 0 (except for
\code{Regularization=CMTL})}

\item{opts}{Options of the optimization procedure. One can set the
initial search point, the tolerance and the maximized number of
iterations using this parameter. The default value is
\code{list(init=0,  tol=10^-3, maxIter=1000)}}

\item{G}{A matrix to encode the network information. This parameter
is only used in the MTL with graph structure (\code{Regularization=Graph} )}

\item{k}{A positive number to modulate the structure of clusters
with the default of 2. This parameter is only used in MTL with
clustering structure (\code{Regularization=CMTL} ) Note, the larger number is adapted to more
complex clustering structure.}
}
\value{
The trained model including the coefficient matrix \code{W}
    and intercepts \code{C} and related meta information
}
\description{
Train a multi-task learning model.
}
\examples{
#create the example data
data<-Create_simulated_data(Regularization="L21", type="Regression")
#train a MTL model
#cold-start
model<-MTL(data$X, data$Y, type="Regression", Regularization="L21",
    Lam1=0.1, Lam2=0, opts=list(init=0,  tol=10^-6, maxIter=1500))
#warm-start
model<-MTL(data$X, data$Y, type="Regression", Regularization="L21",
    Lam1=0.1, Lam1_seq=10^seq(1,-4, -1), Lam2=0, opts=list(init=0,  tol=10^-6, maxIter=1500))
#meta-information
str(model)
#plot the historical objective values
plotObj(model)
}
