% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stackret.R
\name{StackRet}
\alias{StackRet}
\title{Stack Rets for ggplot}
\usage{
StackRet(rets, date)
}
\arguments{
\item{rets}{multivariate data, arranged by column}

\item{date}{vector of common information for variables}
}
\value{
Suitable tibble data for plot by group in ggplot
}
\description{
Change the arrangement of multivariate data to generate suitable data for ggplot.
}
\examples{
names <- c("swan", "bear", "tiger")
date <- as.Date("2015-01-01") + days(0:179)
mu <- c(0.2, 0.08, 0.1)
sigma <- matrix(c(1, 0.25, -0.3, 0.25, 0.25, 0, -0.3, 0, 0.36), 3, 3)
allret <- rMvReturnSim(names, date, mu, sigma)
StackRet(allret, date)
}
