% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DfReadDataFile.R
\name{DfReadDataFile}
\alias{DfReadDataFile}
\title{Read a data file}
\usage{
DfReadDataFile(
  fileName,
  format = "JAFROC",
  newExcelFileFormat = FALSE,
  delimiter = ",",
  sequentialNames = FALSE
)
}
\arguments{
\item{fileName}{A string specifying the name of the file. 
The file-extension must match the format specified below}

\item{format}{A string specifying the format of the data in the file. 
It can be \code{"JAFROC"}, the default, which requires a .xlsx Excel file,
\bold{not .xls}, \code{"MRMC"} or \code{"iMRMC"}.}

\item{newExcelFileFormat}{This argument only applies to the \code{"JAFROC"} format. 
The default is \code{FALSE}. if \code{TRUE} the function accommodates 3 
additional columns
in the \code{Truth} worksheet. If \code{FALSE}, the original function (as in version 
1.2.0) is used and the three extra columns, if present, throws an error.}

\item{delimiter}{The string delimiter to be used for the \code{"MRMC"} 
format ("," is the default).
This parameter is not used when reading \code{"JAFROC"} 
or \code{"iMRMC"} data files.}

\item{sequentialNames}{A logical variable: if \code{TRUE}, consecutive integers 
(starting from 1) will be used as the 
treatment and reader IDs (i.e., names). Otherwise, treatment 
and reader IDs in the original data file will be used.}
}
\value{
A dataset with the structure specified in \code{\link{RJafroc-package}}.
}
\description{
Read a disk file and create a dataset object from it.
}
\examples{


\donttest{
fileName <- system.file("extdata", "Roc.xlsx", 
package = "RJafroc", mustWork = TRUE)
RocDataXlsx <- DfReadDataFile(fileName)

fileName <- system.file("extdata", "RocData.csv", 
package = "RJafroc", mustWork = TRUE)
RocDataCsv<- DfReadDataFile(fileName, format = "MRMC")

fileName <- system.file("extdata", "RocData.imrmc", 
package = "RJafroc", mustWork = TRUE)
RocDataImrmc<- DfReadDataFile(fileName, format = "iMRMC")

fileName <- system.file("extdata", "Froc.xlsx", 
package = "RJafroc", mustWork = TRUE)
FrocDataXlsx <- DfReadDataFile(fileName, sequentialNames = TRUE)
}

}
