% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StSignificanceTesting.R
\name{StSignificanceTesting}
\alias{StSignificanceTesting}
\title{Perform DBM or OR significance testing}
\usage{
StSignificanceTesting(
  dataset,
  FOM,
  FPFValue = 0.2,
  alpha = 0.05,
  method = "DBMH",
  covEstMethod = "Jackknife",
  nBoots = 200,
  option = "ALL",
  tempOrgCode = FALSE
)
}
\arguments{
\item{dataset}{The dataset to be analyzed, see \code{\link{RJafroc-package}}. 
\bold{Must have two or more treatments and two or more readers.}}

\item{FOM}{The figure of merit, see \code{\link{UtilFigureOfMerit}}}

\item{FPFValue}{Only needed for \code{LROC} data \strong{and} FOM = "PCL" or "ALROC";
where to evaluate a partial curve based figure of merit. The default is 0.2.}

\item{alpha}{The significance level of the test of the null hypothesis that all 
treatment effects are zero; the default is 0.05}

\item{method}{The significance testing method to be used. There are two options: 
\code{"DBMH"} (the default) or \code{"ORH"}, representing the Dorfman-Berbaum-Metz
and the Obuchowski-Rockette significance testing methods, respectively.}

\item{covEstMethod}{The covariance matrix estimation method
   in \code{ORH} analysis (for \code{method = "DBMH"} the jackknife is always used).
   \itemize{ 
   \item \code{"Jackknife"}, the default, 
   \item \code{"Bootstrap"}, in which case \code{nBoots} (above) is relevant 
   \item \code{"DeLong"}; requires \code{FOM = "Wilcoxon"}, otherwise 
   an error results.
}}

\item{nBoots}{The number of bootstraps (defaults to 200), relevant only if 
\code{covEstMethod = "Bootstrap"} and \code{method = "ORH"}}

\item{option}{Determines which factors are regarded as random vs. fixed:
\itemize{ 
   \item \code{"RRRC"} = random-reader random case, 
   \item \code{"FRRC"} = fixed-reader random case, 
   \item \code{"RRFC"} = random-reader fixed case, 
   \item \code{"ALL"} = outputs the results of \code{"RRRC"}, \code{"FRRC"} 
   and \code{"RRFC"} analyses
}}

\item{tempOrgCode, }{default FALSE; if TRUE, then code from version 0.0.1 of RJafroc
is used (see RJafroc_0.0.1.tar). This is intended to check against errors 
that crept in subsequent to 
the original version as I attempted to improve the organization of the code and the output.
As implicit in the name of this temporary flag, it will eventually be removed.}
}
\value{
\strong{For \code{method = "DBMH"}  the returned list has 15 members:}

\item{fomArray}{Figure of merit array: see return of \code{\link{UtilFigureOfMerit}}}

\item{anovaY}{ ANOVA table of the pseudovalues, over all treatments}

\item{anovaYi}{ANOVA table of the pseudovalues, for each treatment}

\item{varComp}{The variance components of the DBM pseudovalue mode; 
   6 values, in the following order: \code{varR}, \code{varC}, 
   \code{varTR}, \code{varTC}, \code{varRC} and \code{varErr}}

\item{FTestStatsRRRC}{Results of the F-test for RRRC \strong{random reader random case}
   analysis; contains the following items: \code{fRRRC} - the value of the F-statistic, 
   \code{ndfRRRC} - the numerator degrees of freedom, \code{ddfRRRC} - 
   the denominator degrees of freedom and \code{pRRRC} - the pvalue}

\item{ciDiffTrtRRRC}{For RRRC analysis, the confidence intervals and related 
   statistics for the FOM differences between pairs of treatments}

\item{ciAvgRdrEachTrtRRRC}{For RRRC analysis, the confidence intervals 
   and related test statistics for rdr. avg. FOM in each treatment}

\item{FTestStatsFRRC}{As for \code{FTestStatsRRRC} except that this is 
   for \strong{fixed-reader random-case} (FRRC) analysis}

\item{ciDiffTrtFRRC}{For FRRC analysis, the confidence intervals and related 
   test statistics for the FOM differences between pairs of treatments}

\item{ciAvgRdrEachTrtFRRC}{For FRRC analysis, the confidence intervals and 
   related tests for rdr. avg. FOM in each treatment}

\item{msAnovaEachRdrFRRC}{The mean squares table of the ANOVA of the 
   pseudovalues for each reader (based on data for the specified reader)}

\item{ciDiffTrtEachRdrFRRC}{The confidence intervals and related tests of the 
   FOM differences between pairs of treatments for each reader}

\item{FTestStatsRRFC}{As for \code{FTestStatsRRRC} except that this is 
   for \strong{random-reader fixed-case} (RRFC) analysis}

\item{ciDiffTrtRRFC}{For RRFC analysis, the confidence intervals and 
   related test statistics for the FOM differences between pairs of treatments}

\item{ciAvgRdrEachTrtRRFC}{For RRFC analysis, the confidence intervals 
   and related tests for reader averaged FOM in each treatment}

\strong{For method = "ORH" the return list has 14 members:}

\item{fomArray}{Figure of merit array: see return of \code{\link{UtilFigureOfMerit}}}

\item{meanSquares}{List with 3 members: \code{msT}, \code{msR}, \code{msTR}}

\item{varComp}{The variance components of the OR figure of merit model; 
   6 values, listed in the following order: \code{varR}, \code{varTR}, \code{cov1}, 
   \code{cov2}, \code{cov3} and \code{var}}

\item{FTestStatsRRRC}{Results of the F-test for RRRC \strong{random reader random case}
   analysis; contains the following items: \code{fRRRC} - the value of the F-statistic, 
   \code{ndfRRRC} - the numerator degrees of freedom, \code{ddfRRRC} - 
   the denominator degrees of freedom and \code{pRRRC} - the pvalue}

\item{ciDiffTrtRRRC}{Same as in \code{DBMH} method}

\item{ciAvgRdrEachTrtRRRC}{Same as in \code{DBMH} method}

\item{FTestStatsFRRC}{Same as \code{FTestStatsRRRC}, but 
   now treating reader as a fixed effect}

\item{ciDiffTrtFRRC}{Same as in \code{DBMH} method}

\item{ciAvgRdrEachTrtFRRC}{Same as in \code{DBMH} method}

\item{ciDiffTrtEachRdrFRRC}{Same as in \code{DBMH} method}

\item{varCovEachRdr}{Var and Cov1 
   estimates for each reader}

\item{FTestStatsRRFC}{Same as \code{FTestStatsRRRC}, but 
   now treating case as a fixed effect}

\item{ciDiffTrtRRFC}{Same as in \code{DBMH} method}

\item{ciAvgRdrEachTrtRRFC}{Same as in \code{DBMH} method}
}
\description{
Performs Dorfman-Berbaum-Metz (DBM) or Obuchowski-Rockette (OR) 
   significance testing (with Hillis' improvements), for specified dataset; 
   significance testing refers to analysis designed to assign a P-value, 
   and other statistics, for 
   rejecting the null hypothesis (NH) that the reader-averaged 
   figure of merit (FOM) difference between treatments is zero. The results of 
   the analysis are better visualized in the text or  
   Excel-formatted files produced by \code{\link{UtilOutputReport}}.
}
\examples{
StSignificanceTesting(dataset02,FOM = "Wilcoxon", method = "DBMH") 
StSignificanceTesting(dataset02,FOM = "Wilcoxon", method = "ORH")

\donttest{
StSignificanceTesting(dataset05, FOM = "wAFROC")
StSignificanceTesting(dataset05, FOM = "HrAuc", method = "DBMH") 
StSignificanceTesting(dataset05, FOM = "SongA1", method = "DBMH") 
StSignificanceTesting(dataset05, FOM = "SongA2", method = "DBMH") 
StSignificanceTesting(dataset05, FOM = "FOM_wAFROC1", method = "DBMH")
StSignificanceTesting(dataset05, FOM = "FOM_AFROC1", method = "DBMH")
StSignificanceTesting(dataset05, FOM = "FOM_AFROC", method = "DBMH")
} 


}
\references{
Dorfman DD, Berbaum KS, Metz CE (1992) ROC characteristic rating analysis: 
Generalization to the Population of Readers and Patients with the Jackknife method, Invest. Radiol. 27, 723-731.

Obuchowski NA, Rockette HE (1995) Hypothesis Testing of the Diagnostic Accuracy for Multiple Diagnostic Tests:  
An ANOVA Approach with Dependent Observations, Communications in Statistics: Simulation and Computation 24, 285-308.

Hillis SL (2014) A marginal-mean ANOVA approach for analyzing multireader multicase radiological imaging data, 
Statistics in medicine 33, 330-360.

Chakraborty DP (2017) \emph{Observer Performance Methods for Diagnostic Imaging - Foundations, 
Modeling, and Applications with R-Based Examples}, CRC Press, Boca Raton, FL. 
\url{https://www.crcpress.com/Observer-Performance-Methods-for-Diagnostic-Imaging-Foundations-Modeling/Chakraborty/p/book/9781482214840}
}
