/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.linearfilters;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.linearfilters.AbstractFiniteFilter;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.IFiniteFilter;
import ec.tstoolkit.maths.linearfilters.LinearFilterException;
import ec.tstoolkit.maths.matrices.Gauss;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SparseSystemSolver;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.utilities.Arrays2;

public class SymmetricFilter
extends AbstractFiniteFilter {
    public static final SymmetricFilter ZERO = new SymmetricFilter(Polynomial.ZERO);
    public static final SymmetricFilter ONE = new SymmetricFilter(Polynomial.ONE);
    private final Polynomial m_p;

    public static SymmetricFilter add(double d, SymmetricFilter f) {
        return f.plus(d);
    }

    public static SymmetricFilter createFromFilter(IFiniteFilter f) {
        double[] w = f.getWeights();
        double[] c = new double[w.length];
        for (int i = 0; i < w.length; ++i) {
            for (int j = i; j < w.length; ++j) {
                int n = j - i;
                c[n] = c[n] + w[i] * w[j];
            }
        }
        return SymmetricFilter.of(c);
    }

    public static SymmetricFilter createFromWeights(Polynomial w) {
        int d = w.getDegree();
        if (d % 2 != 0) {
            throw new LinearFilterException("lf_err_sfilter");
        }
        int n = d / 2;
        double[] wc = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            double x = w.get(n + i);
            if (Math.abs(x - w.get(n - i)) > Polynomial.getEpsilon()) {
                throw new LinearFilterException("lf_err_sfilter");
            }
            wc[i] = x;
        }
        return SymmetricFilter.of(wc);
    }

    public static SymmetricFilter multiply(double d, SymmetricFilter f) {
        return f.times(d);
    }

    public static SymmetricFilter subtract(double d, SymmetricFilter f) {
        Polynomial tmp = f.m_p.negate().plus(d);
        return new SymmetricFilter(tmp);
    }

    public static SymmetricFilter of(double[] c) {
        if (c.length == 1) {
            if (c[0] == 1.0) {
                return ONE;
            }
            if (c[0] == 0.0) {
                return ZERO;
            }
        }
        return new SymmetricFilter(Polynomial.of(c));
    }

    public SymmetricFilter(Polynomial p) {
        this.m_p = p.adjustDegree();
    }

    public BackFilter decompose(BackFilter Q) throws MatrixException {
        int nc;
        if (Q.getLength() == 1) {
            double[] data = this.m_p.getCoefficients();
            data[0] = data[0] / 2.0;
            Polynomial tmp = Polynomial.of(data);
            double q0 = Q.get(0);
            if (q0 != 1.0) {
                tmp = tmp.divide(q0);
            }
            return new BackFilter(tmp);
        }
        Polynomial q = Q.getPolynomial();
        Polynomial c = this.m_p;
        int nq = q.getDegree();
        int r = nq > (nc = c.getDegree()) ? nq : nc;
        Matrix a = new Matrix(r + 1, r + 1);
        double[] mc = new double[r + 1];
        for (int i = 0; i <= r; ++i) {
            mc[r - i] = i <= nc ? c.get(i) : 0.0;
            for (int j = 0; j <= i; ++j) {
                if (i - j <= nq) {
                    double a1 = q.get(i - j);
                    a.set(i, j, a.get(i, j) + a1);
                }
                if (r - i + j > nq) continue;
                double a2 = q.get(r - i + j);
                a.set(i, r - j, a.get(i, r - j) + a2);
            }
        }
        Householder qr = new Householder(false);
        qr.decompose(a);
        double[] g = qr.solve(mc);
        Arrays2.reverse(g);
        return BackFilter.of(g);
    }

    public BackFilter decompose2(BackFilter qfilter) throws MatrixException {
        int nc;
        if (qfilter.getLength() == 1) {
            double[] data = this.m_p.getCoefficients();
            data[0] = data[0] / 2.0;
            Polynomial tmp = Polynomial.of(data);
            double q0 = qfilter.get(0);
            if (q0 != 1.0) {
                tmp = tmp.divide(q0);
            }
            return new BackFilter(tmp);
        }
        Polynomial q = qfilter.getPolynomial();
        Polynomial c = this.m_p;
        int nq = q.getDegree();
        int r = nq > (nc = c.getDegree()) ? nq : nc;
        Matrix a = new Matrix(r + 1, r + 2);
        for (int i = 0; i <= r; ++i) {
            a.set(r - i, r + 1, i <= nc ? c.get(i) : 0.0);
            for (int j = 0; j <= i; ++j) {
                if (i - j <= nq) {
                    double a1 = q.get(i - j);
                    a.set(i, j, a.get(i, j) + a1);
                }
                if (r - i + j > nq) continue;
                double a2 = q.get(r - i + j);
                a.set(i, r - j, a.get(i, r - j) + a2);
            }
        }
        if (!SparseSystemSolver.solve(a)) {
            throw new LinearFilterException("lf_err_sfilter");
        }
        double[] g = new double[r + 1];
        a.column(r + 1).copyTo(g, 0);
        Arrays2.reverse(g);
        return BackFilter.of(g);
    }

    @Override
    protected void defaultFilter(DataBlock in, DataBlock out, int lb, int ub) {
        double[] pin = in.getData();
        double[] pout = out.getData();
        int istart = in.getStartPosition();
        int iinc = in.getIncrement();
        int ostart = out.getStartPosition();
        int oend = out.getEndPosition();
        int oinc = out.getIncrement();
        if (iinc == 1 && oinc == 1) {
            int i = istart + ub;
            for (int j = ostart; j < oend; ++j) {
                double s = pin[i] * this.m_p.get(0);
                for (int k = 1; k <= ub; ++k) {
                    s += this.m_p.get(k) * (pin[i - k] + pin[i + k]);
                }
                pout[j] = s;
                ++i;
            }
        } else {
            int i = istart + ub * iinc;
            for (int j = ostart; j != oend; j += oinc) {
                double s = pin[i] * this.m_p.get(0);
                int k = 1;
                int l = iinc;
                while (k <= ub) {
                    s += this.m_p.get(k) * (pin[i - l] + pin[i + l]);
                    ++k;
                    l += iinc;
                }
                pout[j] = s;
                i += iinc;
            }
        }
    }

    @Override
    public Complex frequencyResponse(double freq) {
        double cos1;
        int idx = 0;
        double r = this.m_p.get(idx++);
        if (idx >= this.m_p.getDegree() + 1) {
            return Complex.cart(r);
        }
        double cos0 = 1.0;
        double cos = cos1 = Math.cos(freq);
        while (true) {
            r += 2.0 * cos1 * this.m_p.get(idx++);
            if (idx >= this.m_p.getDegree() + 1) break;
            double tmp = 2.0 * cos * cos1 - cos0;
            cos0 = cos1;
            cos1 = tmp;
        }
        return Complex.cart(r);
    }

    public double[] getCoefficients() {
        return this.m_p.getCoefficients();
    }

    public Polynomial getPolynomial() {
        return this.m_p;
    }

    public int getDegree() {
        return this.m_p.getDegree();
    }

    @Override
    public int getLowerBound() {
        return -this.m_p.getDegree();
    }

    @Override
    public int getUpperBound() {
        return this.m_p.getDegree();
    }

    @Override
    public double getWeight(int pos) {
        return pos < 0 ? this.m_p.get(-pos) : this.m_p.get(pos);
    }

    @Override
    public SymmetricFilter mirror() {
        return this;
    }

    public boolean isNull() {
        return this.m_p.isZero();
    }

    public SymmetricFilter minus(double d) {
        return new SymmetricFilter(this.m_p.minus(d));
    }

    public SymmetricFilter minus(SymmetricFilter r) {
        return new SymmetricFilter(this.m_p.minus(r.m_p));
    }

    public SymmetricFilter normalize() {
        double s = this.m_p.get(0);
        for (int i = 1; i <= this.m_p.getDegree(); ++i) {
            s += 2.0 * this.m_p.get(i);
        }
        if (s != 0.0 && s != 1.0) {
            return new SymmetricFilter(this.m_p.times(1.0 / s));
        }
        return this;
    }

    public SymmetricFilter plus(double d) {
        return new SymmetricFilter(this.m_p.plus(d));
    }

    public SymmetricFilter plus(SymmetricFilter r) {
        return new SymmetricFilter(this.m_p.plus(r.m_p));
    }

    public SymmetricFilter times(double d) {
        return new SymmetricFilter(this.m_p.times(d));
    }

    public SymmetricFilter times(SymmetricFilter r) {
        int u;
        int ll = this.m_p.getDegree();
        int lr = r.m_p.getDegree();
        double[] o = new double[ll + lr + 1];
        if (r.m_p.get(0) != 0.0) {
            for (u = 0; u <= ll; ++u) {
                int n = u;
                o[n] = o[n] + this.m_p.get(u) * r.m_p.get(0);
            }
        }
        if (this.m_p.get(0) != 0.0) {
            for (int v = 1; v <= lr; ++v) {
                int n = v;
                o[n] = o[n] + r.m_p.get(v) * this.m_p.get(0);
            }
        }
        for (u = 1; u <= ll; ++u) {
            if (this.m_p.get(u) == 0.0) continue;
            for (int v = 1; v <= lr; ++v) {
                if (r.m_p.get(v) == 0.0) continue;
                double x = this.m_p.get(u) * r.m_p.get(v);
                int n = u + v;
                o[n] = o[n] + x;
                if (u > v) {
                    int n2 = u - v;
                    o[n2] = o[n2] + x;
                    continue;
                }
                if (u < v) {
                    int n3 = v - u;
                    o[n3] = o[n3] + x;
                    continue;
                }
                o[0] = o[0] + 2.0 * x;
            }
        }
        return SymmetricFilter.of(o);
    }

    public static class Decomposer {
        private static final int MAXITER = 50;
        private static final double EPS = 1.0E-9;
        private int nur_;
        private Polynomial cur_;
        private static Polynomial D = Polynomial.of(new double[]{-1.0, 2.0, -1.0});

        public BackFilter factorize(SymmetricFilter filter) {
            this.nur_ = 0;
            this.cur_ = filter.m_p;
            try {
                int i;
                DataBlock C = new DataBlock(filter.getCoefficients());
                int n = C.getLength();
                double w = 0.0;
                do {
                    this.cur_ = this.fullPolynomial(C);
                    w = this.zevaluate(C);
                    if (Math.abs(w) < 1.0E-9) {
                        if (!this.simplifyUnitRoot()) {
                            return null;
                        }
                    } else {
                        if (!(w < 0.0)) break;
                        return null;
                    }
                    C = new DataBlock(this.cur_.rextract(--n - 1, n));
                } while (n > 0);
                DataBlock Ce = C.deepClone();
                int iter = 0;
                double[] q = new double[n + this.nur_];
                DataBlock Q = new DataBlock(q, 0, n, 1);
                Matrix T1 = new Matrix(n, n);
                Matrix T2 = new Matrix(n, n);
                C.mul(1.0 / w);
                Ce.mul(1.0 / w);
                q[0] = 1.0;
                do {
                    T1.clear();
                    T2.clear();
                    for (i = 0; i < n; ++i) {
                        double r = q[i];
                        if (r == 0.0) continue;
                        T1.skewDiagonal(i).set(r);
                        T2.subDiagonal(i).set(r);
                    }
                    Ce.product(T2.rows(), Q);
                    if (Ce.distance(C) / (double)n < 1.0E-9) break;
                    T1.add(T2);
                    Ce.add(C);
                    Gauss gauss = new Gauss();
                    gauss.decompose(T1);
                    if (!gauss.isFullRank()) {
                        return null;
                    }
                    gauss.solve(Ce, Q);
                } while (++iter < 50);
                Q.mul(Math.sqrt(w));
                for (i = 0; i < this.nur_; ++i) {
                    for (int j = n + i; j > 0; --j) {
                        int n2 = j;
                        q[n2] = q[n2] - q[j - 1];
                    }
                }
                return BackFilter.of(q);
            }
            catch (Exception e) {
                return null;
            }
        }

        private Polynomial fullPolynomial(DataBlock d) {
            int m = d.getLength() - 1;
            double[] c = new double[2 * m + 1];
            d.copyTo(c, m);
            for (int i = 1; i <= m; ++i) {
                c[m - i] = c[m + i];
            }
            return Polynomial.of(c);
        }

        private double zevaluate(DataBlock c) {
            double z = 2.0 * c.sum();
            return z -= c.get(0);
        }

        private boolean simplifyUnitRoot() {
            Polynomial.Division v = Polynomial.divide(this.cur_, D);
            if (!v.isExact()) {
                return false;
            }
            ++this.nur_;
            this.cur_ = v.getQuotient();
            return true;
        }
    }
}

