% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/medianCut.R
\name{median_cut}
\alias{median_cut}
\title{The median cut algorithm}
\usage{
median_cut(image, vbox, iter = 1)
}
\arguments{
\item{image}{List An image in list form, with three components: red, green, blue}

\item{vbox}{List The output of \code{vbox()} for the given image. A list of image parameters ("min", "max", "med", "ext" and "volume")}

\item{iter}{Integer The number attached to the names of the two new images.}
}
\value{
Two new images in a list, each separated into rgb components
}
\description{
Cut an rgb cube into two color cubes, each with as imilar number of
elements.
}
\details{
Represents the rgb colorspace as a cube, with side lengths
based on the red, green, and blue extents (difference between
maximum and minimum within-color values).

The algorithm takes the side with the largest extent (extent information
is passed in via the \code{vbox()} parameter),
and splits the cube along the median value.

Both halves of the cube are then returned.
}
\seealso{
\code{\link{vbox}} \code{\link{image_palette}}
}

