/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.ContrastEnhancer;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;

public class RankFilters
implements ExtendedPlugInFilter,
DialogListener {
    public static final int MEAN = 0;
    public static final int MIN = 1;
    public static final int MAX = 2;
    public static final int VARIANCE = 3;
    public static final int MEDIAN = 4;
    public static final int OUTLIERS = 5;
    public static final int DESPECKLE = 6;
    private static final int BRIGHT_OUTLIERS = 0;
    private static final int DARK_OUTLIERS = 1;
    private static final String[] outlierStrings = new String[]{"Bright", "Dark"};
    private static double radius = 2.0;
    private static double threshold = 50.0;
    private static int whichOutliers = 0;
    private int filterType = 4;
    int flags = 16834655;
    private ImagePlus imp;
    private int nPasses = 1;
    private int pass;
    protected int kRadius;
    protected int kNPoints;
    protected int[] lineRadius;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        if (string.equals("mean")) {
            this.filterType = 0;
        } else if (string.equals("min")) {
            this.filterType = 1;
        } else if (string.equals("max")) {
            this.filterType = 2;
        } else if (string.equals("variance")) {
            this.filterType = 3;
        } else if (string.equals("median")) {
            this.filterType = 4;
        } else if (string.equals("outliers")) {
            this.filterType = 5;
        } else if (string.equals("despeckle")) {
            this.filterType = 6;
        } else {
            if (string.equals("masks")) {
                this.showMasks();
                return 4096;
            }
            IJ.error("RankFilters", "Argument missing or undefined: " + string);
            return 4096;
        }
        return this.flags;
    }

    public int showDialog(ImagePlus imagePlus, String string, PlugInFilterRunner plugInFilterRunner) {
        if (this.filterType == 6) {
            this.filterType = 4;
            this.makeKernel(1.0);
        } else {
            int n;
            GenericDialog genericDialog = new GenericDialog(string + "...");
            genericDialog.addNumericField("Radius", radius, 1, 6, "pixels");
            int n2 = n = imagePlus.getType() == 2 ? 2 : 0;
            if (this.filterType == 5) {
                genericDialog.addNumericField("Threshold", threshold, n);
                genericDialog.addChoice("Which Outliers", outlierStrings, outlierStrings[whichOutliers]);
            }
            genericDialog.addPreviewCheckbox(plugInFilterRunner);
            genericDialog.addDialogListener(this);
            genericDialog.showDialog();
            if (genericDialog.wasCanceled()) {
                return 4096;
            }
            IJ.register(this.getClass());
        }
        return IJ.setupDialog(imagePlus, this.flags);
    }

    public boolean dialogItemChanged(GenericDialog genericDialog, AWTEvent aWTEvent) {
        radius = genericDialog.getNextNumber();
        if (this.filterType == 5) {
            threshold = genericDialog.getNextNumber();
            whichOutliers = genericDialog.getNextChoiceIndex();
        }
        if (genericDialog.invalidNumber() || radius < 0.0 || radius > 1000.0 || this.filterType == 5 && threshold < 0.0) {
            return false;
        }
        this.makeKernel(radius);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ImageProcessor imageProcessor) {
        int n;
        int[] nArray;
        RankFilters rankFilters = this;
        synchronized (rankFilters) {
            nArray = (int[])this.lineRadius.clone();
            n = this.kRadius;
            int n2 = this.kNPoints;
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        ++this.pass;
        this.doFiltering((FloatProcessor)imageProcessor, n, nArray, this.filterType, whichOutliers, (float)threshold);
        if (this.imp != null && this.imp.getBitDepth() != 24 && this.imp.getRoi() == null && this.filterType == 3) {
            new ContrastEnhancer().stretchHistogram(this.imp.getProcessor(), 0.5);
        }
    }

    public void doFiltering(FloatProcessor floatProcessor, int n, int[] nArray, int n2, int n3, float f) {
        int n4;
        float f2;
        if (this.imp != null && IJ.escapePressed()) {
            return;
        }
        boolean bl = n2 == 1 || n2 == 2;
        boolean bl2 = bl || n2 == 5;
        boolean bl3 = n2 == 0 || n2 == 3;
        boolean bl4 = n2 == 4 || n2 == 5;
        double[] dArray = bl3 ? new double[2] : null;
        float[] fArray = bl4 ? new float[this.kNPoints] : null;
        float[] fArray2 = bl4 ? new float[this.kNPoints] : null;
        float f3 = f2 = n2 == 1 ? -1.0f : 1.0f;
        if (n2 == 5) {
            f2 = floatProcessor.isInvertedLut() == (n3 == 1) ? -1.0f : 1.0f;
        }
        float[] fArray3 = (float[])floatProcessor.getPixels();
        int n5 = floatProcessor.getWidth();
        int n6 = floatProcessor.getHeight();
        Rectangle rectangle = floatProcessor.getRoi();
        int n7 = rectangle.x - n;
        int n8 = rectangle.x + rectangle.width;
        int n9 = n8 + n;
        int n10 = 2 * n + 1;
        int n11 = n9 - n7;
        int n12 = n7 > 0 ? n7 : 0;
        int n13 = n9 < n5 ? n9 : n5;
        int n14 = n13 - n12;
        boolean bl5 = n < 2;
        float[] fArray4 = new float[n11 * n10];
        int n15 = 0;
        for (n4 = rectangle.y - n; n4 < rectangle.y + n; ++n4) {
            int n16 = n7;
            while (n16 < n9) {
                fArray4[n15] = fArray3[(n16 < 0 ? 0 : (n16 >= n5 ? n5 - 1 : n16)) + n5 * (n4 < 0 ? 0 : (n4 >= n6 ? n6 - 1 : n4))];
                ++n16;
                ++n15;
            }
        }
        n4 = 2 * n;
        float f4 = fArray4[0];
        Thread thread = Thread.currentThread();
        long l = System.currentTimeMillis();
        for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
            int n17;
            long l2 = System.currentTimeMillis();
            if (l2 - l > 100L) {
                l = l2;
                if (thread.isInterrupted()) {
                    return;
                }
                this.showProgress((double)i / (double)rectangle.height);
                if (this.imp != null && IJ.escapePressed()) {
                    floatProcessor.reset();
                    ImageProcessor imageProcessor = this.imp.getProcessor();
                    if (imageProcessor.getNChannels() > 1) {
                        imageProcessor.reset();
                    }
                    return;
                }
            }
            if ((n17 = i + n) >= n6) {
                n17 = n6 - 1;
            }
            float f5 = fArray3[n5 * n17];
            float f6 = fArray3[n5 - 1 + n5 * n17];
            int n18 = n11 * n4;
            int n19 = n7;
            while (n19 < 0) {
                fArray4[n18] = f5;
                ++n19;
                ++n18;
            }
            System.arraycopy(fArray3, n12 + n5 * n17, fArray4, n18, n14);
            n18 += n14;
            n19 = n5;
            while (n19 < n9) {
                fArray4[n18] = f6;
                ++n19;
                ++n18;
            }
            n4 = (n4 + 1) % n10;
            float f7 = 0.0f;
            boolean bl6 = true;
            int n20 = rectangle.x;
            int n21 = n20 + i * n5;
            int n22 = n;
            while (n20 < n8) {
                if (bl6) {
                    bl6 = bl5;
                    if (bl2) {
                        f7 = this.getAreaMax(fArray4, n11, n22, nArray, n10, 0, -3.4028235E38f, f2);
                    }
                    if (bl) {
                        fArray3[n21] = f7 * f2;
                    } else if (bl3) {
                        this.getAreaSums(fArray4, n11, n22, nArray, n10, dArray);
                    }
                } else if (bl2) {
                    float f8 = this.getSideMax(fArray4, n11, n22, nArray, n10, true, f2);
                    if (f8 >= f7) {
                        f7 = f8;
                    } else {
                        float f9 = this.getSideMax(fArray4, n11, n22, nArray, n10, false, f2);
                        if (f9 >= f7) {
                            f7 = this.getAreaMax(fArray4, n11, n22, nArray, n10, 1, f8, f2);
                        }
                    }
                    if (bl) {
                        fArray3[n21] = f7 * f2;
                    }
                } else if (bl3) {
                    this.addSideSums(fArray4, n11, n22, nArray, n10, dArray);
                }
                if (bl4) {
                    if (n2 == 4 || fArray3[n21] * f2 + f < f7) {
                        f4 = this.getMedian(fArray4, n11, n22, nArray, n10, fArray, fArray2, f4);
                        if (n2 == 4 || fArray3[n21] * f2 + f < f4 * f2) {
                            fArray3[n21] = f4;
                        }
                    }
                } else if (bl3) {
                    fArray3[n21] = n2 == 0 ? (float)(dArray[0] / (double)this.kNPoints) : (float)((dArray[1] - dArray[0] * dArray[0] / (double)this.kNPoints) / (double)this.kNPoints);
                }
                ++n20;
                ++n21;
                ++n22;
            }
            n20 = nArray[n10 - 1];
            System.arraycopy(nArray, 0, nArray, 1, n10 - 1);
            nArray[0] = n20;
        }
    }

    public void rank(ImageProcessor imageProcessor, double d, int n) {
        FloatProcessor floatProcessor = null;
        for (int i = 0; i < imageProcessor.getNChannels(); ++i) {
            this.makeKernel(d);
            floatProcessor = imageProcessor.toFloat(i, floatProcessor);
            this.doFiltering(floatProcessor, this.kRadius, this.lineRadius, n, 0, 50.0f);
            imageProcessor.setPixels(i, floatProcessor);
        }
    }

    private float getAreaMax(float[] fArray, int n, int n2, int[] nArray, int n3, int n4, float f, float f2) {
        for (int i = 0; i < n3; ++i) {
            int n5 = n2 - nArray[i];
            int n6 = i * n + n5;
            while (n5 <= n2 + nArray[i] - n4) {
                float f3 = fArray[n6] * f2;
                if (f < f3) {
                    f = f3;
                }
                ++n5;
                ++n6;
            }
        }
        return f;
    }

    private float getSideMax(float[] fArray, int n, int n2, int[] nArray, int n3, boolean bl, float f) {
        float f2 = -3.4028235E38f;
        for (int i = 0; i < n3; ++i) {
            int n4 = bl ? n2 + nArray[i] : n2 - nArray[i] - 1;
            int n5 = i * n + n4;
            float f3 = fArray[n5] * f;
            if (!(f2 < f3)) continue;
            f2 = f3;
        }
        return f2;
    }

    private void getAreaSums(float[] fArray, int n, int n2, int[] nArray, int n3, double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n3; ++i) {
            int n4 = n2 - nArray[i];
            int n5 = i * n + n4;
            while (n4 <= n2 + nArray[i]) {
                float f = fArray[n5];
                d += (double)f;
                d2 += (double)(f * f);
                ++n4;
                ++n5;
            }
        }
        dArray[0] = d;
        dArray[1] = d2;
    }

    private void addSideSums(float[] fArray, int n, int n2, int[] nArray, int n3, double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n3; ++i) {
            int n4 = i * n + n2;
            float f = fArray[n4 + nArray[i]];
            d += (double)f;
            d2 += (double)(f * f);
            f = fArray[n4 - nArray[i] - 1];
            d -= (double)f;
            d2 -= (double)(f * f);
        }
        dArray[0] = dArray[0] + d;
        dArray[1] = dArray[1] + d2;
    }

    private float getMedian(float[] fArray, int n, int n2, int[] nArray, int n3, float[] fArray2, float[] fArray3, float f) {
        int n4 = this.kNPoints / 2;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            int n7 = n2 - nArray[i];
            int n8 = i * n + n7;
            while (n7 <= n2 + nArray[i]) {
                float f2 = fArray[n8];
                if (f2 > f) {
                    fArray2[n5] = f2;
                    ++n5;
                } else if (f2 < f) {
                    fArray3[n6] = f2;
                    ++n6;
                }
                ++n7;
                ++n8;
            }
        }
        if (n5 > n4) {
            return RankFilters.findNthLowestNumber(fArray2, n5, n5 - n4 - 1);
        }
        if (n6 > n4) {
            return RankFilters.findNthLowestNumber(fArray3, n6, n4);
        }
        return f;
    }

    public static float findNthLowestNumber(float[] fArray, int n, int n2) {
        int n3 = 0;
        int n4 = n - 1;
        float f = fArray[n2];
        while (n3 < n4) {
            int n5 = n3;
            int n6 = n4;
            while (true) {
                if (fArray[n5] < f) {
                    ++n5;
                    continue;
                }
                while (f < fArray[n6]) {
                    --n6;
                }
                float f2 = fArray[n6];
                fArray[n6] = fArray[n5];
                fArray[n5] = f2;
                if (--n6 < n2 || ++n5 > n2) break;
            }
            if (n6 < n2) {
                n3 = n5;
            }
            if (n2 < n5) {
                n4 = n6;
            }
            f = fArray[n2];
        }
        return f;
    }

    public synchronized void makeKernel(double d) {
        if (d >= 1.5 && d < 1.75) {
            d = 1.75;
        } else if (d >= 2.5 && d < 2.85) {
            d = 2.85;
        }
        int n = (int)(d * d) + 1;
        this.kRadius = (int)Math.sqrt((double)n + 1.0E-10);
        this.lineRadius = new int[2 * this.kRadius + 1];
        this.lineRadius[this.kRadius] = this.kRadius;
        this.kNPoints = 2 * this.kRadius + 1;
        for (int i = 1; i <= this.kRadius; ++i) {
            int n2;
            this.lineRadius[this.kRadius + i] = n2 = (int)Math.sqrt((double)(n - i * i) + 1.0E-10);
            this.lineRadius[this.kRadius - i] = n2;
            this.kNPoints += 4 * n2 + 2;
        }
    }

    void showMasks() {
        int n = 150;
        int n2 = 150;
        ImageStack imageStack = new ImageStack(n, n2);
        for (double d = 0.5; d < 50.0; d += 0.5) {
            FloatProcessor floatProcessor = new FloatProcessor(n, n2, new int[n * n2]);
            float[] fArray = (float[])((ImageProcessor)floatProcessor).getPixels();
            this.makeKernel(d);
            int n3 = 0;
            int n4 = n2 / 2 - this.kRadius;
            while (n3 < 2 * this.kRadius + 1) {
                int n5 = n / 2 - this.lineRadius[n3];
                int n6 = n5 + n4 * n;
                while (n5 <= n / 2 + this.lineRadius[n3]) {
                    fArray[n6] = 1.0f;
                    ++n5;
                    ++n6;
                }
                ++n3;
                ++n4;
            }
            imageStack.addSlice("radius=" + d + ", size=" + (2 * this.kRadius + 1), floatProcessor);
        }
        new ImagePlus("Masks", imageStack).show();
    }

    public void setNPasses(int n) {
        this.nPasses = n;
        this.pass = 0;
    }

    private void showProgress(double d) {
        d = (double)(this.pass - 1) / (double)this.nPasses + d / (double)this.nPasses;
        IJ.showProgress(d);
    }
}

