/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.MaximumFinder;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class EDM
implements ExtendedPlugInFilter {
    public static final int BYTE_OVERWRITE = 0;
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int FLOAT = 3;
    public static final int ONE = 41;
    public static final int SQRT2 = 58;
    public static final int SQRT5 = 92;
    private ImagePlus imp;
    private ImagePlus outImp;
    private PlugInFilterRunner pfr;
    private String command;
    private int outImageType;
    private ImageStack outStack;
    private int processType;
    private MaximumFinder maxFinder = new MaximumFinder();
    private double progressDone;
    private int nPasses;
    private boolean interrupted;
    private boolean background255;
    private int flags = 98305;
    private static final int EDM = 0;
    private static final int WATERSHED = 1;
    private static final int UEP = 2;
    private static final int VORONOI = 3;
    private static final boolean[] USES_MAX_FINDER = new boolean[]{false, true, true, true};
    private static final boolean[] USES_WATERSHED = new boolean[]{false, true, false, true};
    private static final String[] TITLE_PREFIX = new String[]{"EDM of ", null, "UEPs of ", "Voronoi of "};
    private static final int NO_POINT = -1;
    private static final double MAXFINDER_TOLERANCE = 0.5;
    private static int outputType = 0;

    public int setup(String string, ImagePlus imagePlus) {
        if (string.equals("final")) {
            this.showOutput();
            return 4096;
        }
        this.imp = imagePlus;
        if (string.equals("watershed")) {
            this.processType = 1;
            this.flags += 131072;
        } else if (string.equals("points")) {
            this.processType = 2;
        } else if (string.equals("voronoi")) {
            this.processType = 3;
        }
        if (this.processType != 1) {
            this.outImageType = outputType;
        }
        if (this.outImageType != 0) {
            this.flags |= 0x80;
        }
        if (imagePlus != null) {
            ImageProcessor imageProcessor = imagePlus.getProcessor();
            if (!imageProcessor.isBinary()) {
                IJ.error("8-bit binary image (0 and 255) required.");
                return 4096;
            }
            imageProcessor.resetRoi();
            boolean bl = imagePlus.isInvertedLut();
            this.background255 = bl && Prefs.blackBackground || !bl && !Prefs.blackBackground;
        }
        return this.flags;
    }

    public int showDialog(ImagePlus imagePlus, String string, PlugInFilterRunner plugInFilterRunner) {
        this.pfr = plugInFilterRunner;
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        this.flags = IJ.setupDialog(imagePlus, this.flags);
        if ((this.flags & 0x20) != 0 && this.outImageType != 0) {
            this.outStack = new ImageStack(n, n2, imagePlus.getStackSize());
            this.maxFinder.setNPasses(imagePlus.getStackSize());
        }
        return this.flags;
    }

    public void run(ImageProcessor imageProcessor) {
        int n;
        if (this.interrupted) {
            return;
        }
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        int n4 = this.processType == 3 ? (this.background255 ? 0 : -1) : (n = this.background255 ? -1 : 0);
        if (USES_WATERSHED[this.processType]) {
            this.nPasses = 0;
        }
        FloatProcessor floatProcessor = this.makeFloatEDM(imageProcessor, n, false);
        ImageProcessor imageProcessor2 = null;
        if (USES_MAX_FINDER[this.processType]) {
            boolean bl;
            int n5;
            if (this.processType == 3) {
                floatProcessor.multiply(-1.0);
            }
            if ((imageProcessor2 = this.maxFinder.findMaxima(floatProcessor, 0.5, -808080.0, n5 = USES_WATERSHED[this.processType] ? 2 : 0, false, bl = this.processType != 3)) == null) {
                this.interrupted = true;
                return;
            }
            if (this.processType != 1) {
                if (this.processType == 3) {
                    floatProcessor.multiply(-1.0);
                }
                this.resetMasked(floatProcessor, imageProcessor2, this.processType == 3 ? -1 : 0);
            }
        }
        ImageProcessor imageProcessor3 = null;
        if (this.processType == 1) {
            if (this.background255) {
                imageProcessor2.invert();
            }
            imageProcessor.copyBits(imageProcessor2, 0, 0, 0);
            imageProcessor.setBinaryThreshold();
        } else {
            switch (this.outImageType) {
                case 3: {
                    imageProcessor3 = floatProcessor;
                    break;
                }
                case 2: {
                    floatProcessor.setMinAndMax(0.0, 65535.0);
                    imageProcessor3 = floatProcessor.convertToShort(true);
                    break;
                }
                case 1: {
                    floatProcessor.setMinAndMax(0.0, 255.0);
                    imageProcessor3 = floatProcessor.convertToByte(true);
                    break;
                }
                case 0: {
                    imageProcessor.setPixels(0, floatProcessor);
                    if (!(floatProcessor.getMax() > 255.0)) break;
                    imageProcessor.resetMinAndMax();
                }
            }
        }
        if (this.outImageType != 0) {
            if (this.outStack == null) {
                this.outImp = new ImagePlus(TITLE_PREFIX[this.processType] + this.imp.getShortTitle(), imageProcessor3);
            } else {
                this.outStack.setPixels(imageProcessor3.getPixels(), this.pfr.getSliceNumber());
            }
        }
    }

    public void setNPasses(int n) {
        this.nPasses = n;
        this.progressDone = 0.0;
        if (USES_MAX_FINDER[this.processType]) {
            this.maxFinder.setNPasses(n);
        }
    }

    public void toEDM(ImageProcessor imageProcessor) {
        imageProcessor.setPixels(0, this.makeFloatEDM(imageProcessor, 0, false));
        imageProcessor.resetMinAndMax();
    }

    public void toWatershed(ImageProcessor imageProcessor) {
        FloatProcessor floatProcessor = this.makeFloatEDM(imageProcessor, 0, false);
        ByteProcessor byteProcessor = this.maxFinder.findMaxima(floatProcessor, 0.5, -808080.0, 2, false, true);
        if (byteProcessor != null) {
            imageProcessor.copyBits(byteProcessor, 0, 0, 9);
        }
    }

    public ShortProcessor make16bitEDM(ImageProcessor imageProcessor) {
        FloatProcessor floatProcessor = this.makeFloatEDM(imageProcessor, 0, false);
        floatProcessor.setMinAndMax(0.0, 1598.4146341463415);
        return (ShortProcessor)floatProcessor.convertToShort(true);
    }

    public FloatProcessor makeFloatEDM(ImageProcessor imageProcessor, int n, boolean bl) {
        int n2;
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        FloatProcessor floatProcessor = new FloatProcessor(n3, n4);
        byte[] byArray = (byte[])imageProcessor.getPixels();
        float[] fArray = (float[])floatProcessor.getPixels();
        int n5 = n4 / 100;
        double d = n5 > 0 ? 0.5 / (double)n5 : 0.0;
        for (int i = 0; i < n3 * n4; ++i) {
            if (byArray[i] == n) continue;
            fArray[i] = Float.MAX_VALUE;
        }
        int[][] nArray = new int[2][n3];
        int n6 = Integer.MAX_VALUE;
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[0][n2] = -1;
            nArray[1][n2] = -1;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (bl) {
                n6 = n2 + 1;
            }
            this.edmLine(byArray, fArray, nArray, n3, n2 * n3, n2, n, n6);
            if (n2 % 100 != 0) continue;
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            this.addProgress(d);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[0][n2] = -1;
            nArray[1][n2] = -1;
        }
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            if (bl) {
                n6 = n4 - n2;
            }
            this.edmLine(byArray, fArray, nArray, n3, n2 * n3, n2, n, n6);
            if (n2 % 100 != 0) continue;
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            this.addProgress(d);
        }
        floatProcessor.sqrt();
        return floatProcessor;
    }

    private void edmLine(byte[] byArray, float[] fArray, int[][] nArray, int n, int n2, int n3, int n4, int n5) {
        float f;
        int n6;
        int[] nArray2 = nArray[0];
        int n7 = -1;
        int n8 = -1;
        boolean bl = n5 != Integer.MAX_VALUE;
        int n9 = Integer.MAX_VALUE;
        int n10 = 0;
        while (n10 < n) {
            n6 = nArray2[n10];
            if (byArray[n2] == n4) {
                nArray2[n10] = n10 | n3 << 16;
            } else {
                if (bl) {
                    int n11 = n9 = n10 + 1 < n5 ? (n10 + 1) * (n10 + 1) : n5 * n5;
                }
                if (fArray[n2] > (f = this.minDist2(nArray2, n7, n8, n10, n3, n9))) {
                    fArray[n2] = f;
                }
            }
            n7 = nArray2[n10];
            n8 = n6;
            ++n10;
            ++n2;
        }
        --n2;
        nArray2 = nArray[1];
        n7 = -1;
        n8 = -1;
        n10 = n - 1;
        while (n10 >= 0) {
            n6 = nArray2[n10];
            if (byArray[n2] == n4) {
                nArray2[n10] = n10 | n3 << 16;
            } else {
                if (bl) {
                    int n12 = n9 = n - n10 < n5 ? (n - n10) * (n - n10) : n5 * n5;
                }
                if (fArray[n2] > (f = this.minDist2(nArray2, n7, n8, n10, n3, n9))) {
                    fArray[n2] = f;
                }
            }
            n7 = nArray2[n10];
            n8 = n6;
            --n10;
            --n2;
        }
    }

    private float minDist2(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = n9 = nArray[n3];
        if (n9 != -1 && (n8 = (n3 - (n7 = n9 & 0xFFFF)) * (n3 - n7) + (n4 - (n6 = n9 >> 16 & 0xFFFF)) * (n4 - n6)) < n5) {
            n5 = n8;
        }
        if (n2 != n9 && n2 != -1 && (n8 = (n3 - (n7 = n2 & 0xFFFF)) * (n3 - n7) + (n4 - (n6 = n2 >> 16 & 0xFFFF)) * (n4 - n6)) < n5) {
            n10 = n2;
            n5 = n8;
        }
        if (n != n2 && n != -1 && (n8 = (n3 - (n7 = n & 0xFFFF)) * (n3 - n7) + (n4 - (n6 = n >> 16 & 0xFFFF)) * (n4 - n6)) < n5) {
            n10 = n;
            n5 = n8;
        }
        nArray[n3] = n10;
        return n5;
    }

    private void byteFromFloat(ImageProcessor imageProcessor, FloatProcessor floatProcessor) {
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        byte[] byArray = (byte[])imageProcessor.getPixels();
        float[] fArray = (float[])floatProcessor.getPixels();
        for (int i = 0; i < n * n2; ++i) {
            float f = fArray[i];
            byArray[i] = f < 255.0f ? (int)((int)((double)f + 0.5)) : -1;
        }
    }

    private void resetMasked(FloatProcessor floatProcessor, ImageProcessor imageProcessor, int n) {
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        byte[] byArray = (byte[])imageProcessor.getPixels();
        float[] fArray = (float[])floatProcessor.getPixels();
        for (int i = 0; i < n2 * n3; ++i) {
            if (byArray[i] != n) continue;
            fArray[i] = 0.0f;
        }
    }

    private void showOutput() {
        Object object;
        if (this.interrupted) {
            return;
        }
        if (this.outStack != null) {
            this.outImp = new ImagePlus(TITLE_PREFIX[this.processType] + this.imp.getShortTitle(), this.outStack);
            object = this.imp.getDimensions();
            this.outImp.setDimensions((int)object[2], (int)object[3], (int)object[4]);
            for (int i = 1; i <= this.imp.getStackSize(); ++i) {
                this.outStack.setSliceLabel(this.imp.getStack().getSliceLabel(i), i);
            }
        }
        if (this.outImageType != 0) {
            object = this.outImp.getProcessor();
            if (!Prefs.blackBackground) {
                ((ImageProcessor)object).invertLut();
            }
            ((ImageProcessor)object).resetMinAndMax();
            this.outImp.show();
        }
    }

    private void addProgress(double d) {
        if (this.nPasses == 0) {
            return;
        }
        this.progressDone += d;
        IJ.showProgress(this.progressDone / (double)this.nPasses);
    }

    public static void setOutputType(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid type: " + n);
        }
        outputType = n;
    }

    public static int getOutputType() {
        return outputType;
    }
}

