/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.gui.YesNoCancelDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.MeasurementsWriter;
import ij.plugin.Straightener;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.FloatStatistics;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.text.TextPanel;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Properties;

public class Analyzer
implements PlugInFilter,
Measurements {
    private String arg;
    private ImagePlus imp;
    private ResultsTable rt;
    private int measurements;
    private StringBuffer min;
    private StringBuffer max;
    private StringBuffer mean;
    private StringBuffer sd;
    private static final int[] list = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 512, 2048, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 256, 1024, 4096, 0x200000};
    private static final String MEASUREMENTS = "measurements";
    private static final String MARK_WIDTH = "mark.width";
    private static final String PRECISION = "precision";
    private static boolean unsavedMeasurements;
    public static Color darkBlue;
    private static int systemMeasurements;
    public static int markWidth;
    public static int precision;
    private static float[] umeans;
    private static ResultsTable systemRT;
    private static int redirectTarget;
    private static String redirectTitle;
    private static ImagePlus redirectImage;
    static int firstParticle;
    static int lastParticle;
    private static boolean summarized;
    private static boolean switchingModes;
    private static boolean showMin;

    public Analyzer() {
        this.rt = systemRT;
        this.rt.setPrecision((systemMeasurements & 0x200000) != 0 ? -precision : precision);
        this.measurements = systemMeasurements;
    }

    public Analyzer(ImagePlus imagePlus) {
        this();
        this.imp = imagePlus;
    }

    public Analyzer(ImagePlus imagePlus, int n, ResultsTable resultsTable) {
        this.imp = imagePlus;
        this.measurements = n;
        this.rt = resultsTable;
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.arg = string;
        this.imp = imagePlus;
        IJ.register(Analyzer.class);
        if (string.equals("set")) {
            this.doSetDialog();
            return 4096;
        }
        if (string.equals("sum")) {
            this.summarize();
            return 4096;
        }
        if (string.equals("clear")) {
            if (IJ.macroRunning()) {
                unsavedMeasurements = false;
            }
            Analyzer.resetCounter();
            return 4096;
        }
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        this.measure();
        this.displayResults();
    }

    void doSetDialog() {
        boolean bl;
        Object object;
        String[] stringArray;
        String string = "None";
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            stringArray = new String[]{string};
        } else {
            stringArray = new String[nArray.length + 1];
            stringArray[0] = string;
            for (int i = 0; i < nArray.length; ++i) {
                object = WindowManager.getImage(nArray[i]);
                stringArray[i + 1] = object != null ? ((ImagePlus)object).getTitle() : "";
            }
        }
        ImagePlus imagePlus = WindowManager.getImage(redirectTarget);
        object = imagePlus != null ? imagePlus.getTitle() : string;
        String string2 = Macro.getOptions();
        if (string2 != null && string2.indexOf("circularity ") != -1) {
            Macro.setOptions(string2.replaceAll("circularity ", "shape "));
        }
        if (string2 != null && string2.indexOf("slice ") != -1) {
            Macro.setOptions(string2.replaceAll("slice ", "stack "));
        }
        GenericDialog genericDialog = new GenericDialog("Set Measurements", IJ.getInstance());
        String[] stringArray2 = new String[18];
        boolean[] blArray = new boolean[18];
        stringArray2[0] = "Area";
        blArray[0] = (systemMeasurements & 1) != 0;
        stringArray2[1] = "Mean gray value";
        blArray[1] = (systemMeasurements & 2) != 0;
        stringArray2[2] = "Standard deviation";
        blArray[2] = (systemMeasurements & 4) != 0;
        stringArray2[3] = "Modal gray value";
        blArray[3] = (systemMeasurements & 8) != 0;
        stringArray2[4] = "Min & max gray value";
        blArray[4] = (systemMeasurements & 0x10) != 0;
        stringArray2[5] = "Centroid";
        blArray[5] = (systemMeasurements & 0x20) != 0;
        stringArray2[6] = "Center of mass";
        blArray[6] = (systemMeasurements & 0x40) != 0;
        stringArray2[7] = "Perimeter";
        blArray[7] = (systemMeasurements & 0x80) != 0;
        stringArray2[8] = "Bounding rectangle";
        blArray[8] = (systemMeasurements & 0x200) != 0;
        stringArray2[9] = "Fit ellipse";
        blArray[9] = (systemMeasurements & 0x800) != 0;
        stringArray2[10] = "Shape descriptors";
        blArray[10] = (systemMeasurements & 0x2000) != 0;
        stringArray2[11] = "Feret's diameter";
        blArray[11] = (systemMeasurements & 0x4000) != 0;
        stringArray2[12] = "Integrated density";
        blArray[12] = (systemMeasurements & 0x8000) != 0;
        stringArray2[13] = "Median";
        blArray[13] = (systemMeasurements & 0x10000) != 0;
        stringArray2[14] = "Skewness";
        blArray[14] = (systemMeasurements & 0x20000) != 0;
        stringArray2[15] = "Kurtosis";
        blArray[15] = (systemMeasurements & 0x40000) != 0;
        stringArray2[16] = "Area_fraction";
        blArray[16] = (systemMeasurements & 0x80000) != 0;
        stringArray2[17] = "Stack position";
        blArray[17] = (systemMeasurements & 0x100000) != 0;
        genericDialog.setInsets(0, 0, 0);
        genericDialog.addCheckboxGroup(10, 2, stringArray2, blArray);
        stringArray2 = new String[4];
        blArray = new boolean[4];
        stringArray2[0] = "Limit to threshold";
        blArray[0] = (systemMeasurements & 0x100) != 0;
        stringArray2[1] = "Display label";
        blArray[1] = (systemMeasurements & 0x400) != 0;
        stringArray2[2] = "Invert Y coordinates";
        blArray[2] = (systemMeasurements & 0x1000) != 0;
        stringArray2[3] = "Scientific notation";
        blArray[3] = (systemMeasurements & 0x200000) != 0;
        genericDialog.setInsets(0, 0, 0);
        genericDialog.addCheckboxGroup(2, 2, stringArray2, blArray);
        genericDialog.setInsets(15, 0, 0);
        genericDialog.addChoice("Redirect to:", stringArray, (String)object);
        genericDialog.setInsets(5, 0, 0);
        genericDialog.addNumericField("Decimal places (0-9):", precision, 0, 2, "");
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/analyze.html#set");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n = systemMeasurements;
        this.setOptions(genericDialog);
        int n2 = genericDialog.getNextChoiceIndex();
        redirectTarget = n2 == 0 ? 0 : nArray[n2 - 1];
        redirectTitle = stringArray[n2];
        ImagePlus imagePlus2 = WindowManager.getImage(redirectTarget);
        redirectImage = imagePlus2 != null && imagePlus2.getWindow() == null ? imagePlus2 : null;
        int n3 = (int)genericDialog.getNextNumber();
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > 9) {
            n3 = 9;
        }
        boolean bl2 = bl = (n & 0x200000) != (systemMeasurements & 0x200000);
        if (n3 != precision || bl) {
            precision = n3;
            this.rt.setPrecision((systemMeasurements & 0x200000) != 0 ? -precision : precision);
            this.rt.show("Results");
        }
    }

    void setOptions(GenericDialog genericDialog) {
        int n = systemMeasurements;
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < list.length; ++i) {
            bl = genericDialog.getNextBoolean();
            n2 = list[i];
            if (bl) {
                systemMeasurements |= list[i];
                continue;
            }
            systemMeasurements &= ~list[i];
        }
        if ((n & 0xFFFFFEFF & 0xFFDFFFFF) != (systemMeasurements & 0xFFFFFEFF & 0xFFDFFFFF) && IJ.isResultsWindow()) {
            this.rt.setPrecision((systemMeasurements & 0x200000) != 0 ? -precision : precision);
            this.rt.update(systemMeasurements, this.imp, null);
        }
        if ((systemMeasurements & 0x400) == 0) {
            systemRT.disableRowLabels();
        }
    }

    public void measure() {
        ImageStatistics imageStatistics;
        String string = this.rt.getColumnHeading(35);
        if (!(string != null && string.charAt(0) == 'S' || this.reset())) {
            return;
        }
        lastParticle = 0;
        firstParticle = 0;
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.getType() == 10) {
            this.measurePoint(roi);
            return;
        }
        if (roi != null && roi.isLine()) {
            this.measureLength(roi);
            return;
        }
        if (roi != null && roi.getType() == 8) {
            this.measureAngle(roi);
            return;
        }
        if (Analyzer.isRedirectImage()) {
            imageStatistics = this.getRedirectStats(this.measurements, roi);
            if (imageStatistics == null) {
                return;
            }
        } else {
            imageStatistics = this.imp.getStatistics(this.measurements);
        }
        if (!IJ.isResultsWindow() && IJ.getInstance() != null) {
            this.reset();
        }
        this.saveResults(imageStatistics, roi);
    }

    boolean reset() {
        boolean bl = true;
        if (this.rt.getCounter() > 0) {
            bl = Analyzer.resetCounter();
        }
        if (bl && this.rt.getColumnHeading(35) == null) {
            this.rt.setDefaultHeadings();
        }
        return bl;
    }

    public static boolean isRedirectImage() {
        return redirectTarget != 0;
    }

    public static void setRedirectImage(ImagePlus imagePlus) {
        if (imagePlus == null) {
            redirectTarget = 0;
            redirectTitle = null;
            redirectImage = null;
        } else {
            redirectTarget = imagePlus.getID();
            redirectTitle = imagePlus.getTitle();
            if (imagePlus.getWindow() == null) {
                redirectImage = imagePlus;
            }
        }
    }

    public static ImagePlus getRedirectImage(ImagePlus imagePlus) {
        ImagePlus imagePlus2 = WindowManager.getImage(redirectTarget);
        if (imagePlus2 == null) {
            imagePlus2 = redirectImage;
        }
        if (imagePlus2 == null) {
            IJ.error("Analyzer", "Redirect image (\"" + redirectTitle + "\")\n" + "not found.");
            redirectTarget = 0;
            Macro.abort();
            return null;
        }
        if (imagePlus2.getWidth() != imagePlus.getWidth() || imagePlus2.getHeight() != imagePlus.getHeight()) {
            IJ.error("Analyzer", "Redirect image (\"" + redirectTitle + "\") \n" + "is not the same size as the current image.");
            Macro.abort();
            return null;
        }
        return imagePlus2;
    }

    ImageStatistics getRedirectStats(int n, Roi roi) {
        ImagePlus imagePlus = Analyzer.getRedirectImage(this.imp);
        if (imagePlus == null) {
            return null;
        }
        int n2 = imagePlus.getStackSize();
        if (n2 > 1 && n2 == this.imp.getStackSize()) {
            imagePlus.setSlice(this.imp.getCurrentSlice());
        }
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (this.imp.getTitle().equals("mask") && this.imp.getBitDepth() == 8) {
            imageProcessor.setMask(this.imp.getProcessor());
            imageProcessor.setRoi(0, 0, this.imp.getWidth(), this.imp.getHeight());
        } else {
            imageProcessor.setRoi(roi);
        }
        return ImageStatistics.getStatistics(imageProcessor, n, imagePlus.getCalibration());
    }

    void measurePoint(Roi roi) {
        if (this.rt.getCounter() > 0) {
            int n;
            if (!IJ.isResultsWindow()) {
                this.reset();
            }
            if ((n = this.rt.getColumnIndex("X")) < 0 || !this.rt.columnExists(n)) {
                this.rt.update(this.measurements, this.imp, roi);
            }
        }
        Polygon polygon = roi.getPolygon();
        for (int i = 0; i < polygon.npoints; ++i) {
            ImageProcessor imageProcessor = this.imp.getProcessor();
            imageProcessor.setRoi(polygon.xpoints[i], polygon.ypoints[i], 1, 1);
            ImageStatistics imageStatistics = ImageStatistics.getStatistics(imageProcessor, this.measurements, this.imp.getCalibration());
            this.saveResults(imageStatistics, new PointRoi(polygon.xpoints[i], polygon.ypoints[i]));
            if (i == polygon.npoints - 1) continue;
            this.displayResults();
        }
    }

    void measureAngle(Roi roi) {
        if (this.rt.getCounter() > 0) {
            int n;
            if (!IJ.isResultsWindow()) {
                this.reset();
            }
            if ((n = this.rt.getColumnIndex("Angle")) < 0 || !this.rt.columnExists(n)) {
                this.rt.update(this.measurements, this.imp, roi);
            }
        }
        ImageProcessor imageProcessor = this.imp.getProcessor();
        imageProcessor.setRoi(roi.getPolygon());
        ImageStatistics imageStatistics = new ImageStatistics();
        this.saveResults(imageStatistics, roi);
    }

    /*
     * Enabled aggressive block sorting
     */
    void measureLength(Roi roi) {
        Object object;
        ImageProcessor imageProcessor;
        int n;
        boolean bl;
        if (this.rt.getCounter() > 0) {
            if (!IJ.isResultsWindow()) {
                this.reset();
            }
            bl = false;
            n = this.rt.getColumnIndex("Length");
            if (n < 0 || !this.rt.columnExists(n)) {
                bl = true;
            }
            if (!(roi.getType() != 5 || (n = this.rt.getColumnIndex("Angle")) >= 0 && this.rt.columnExists(n))) {
                bl = true;
            }
            if (bl) {
                this.rt.update(this.measurements, this.imp, roi);
            }
        }
        bl = roi.getType() == 5;
        n = Math.round(roi.getStrokeWidth());
        Rectangle rectangle = null;
        if (bl && n > 1) {
            imageProcessor = this.imp.getProcessor();
            rectangle = imageProcessor.getRoi();
            imageProcessor.setRoi(roi.getPolygon());
        } else if (n > 1) {
            if ((this.measurements & 1) == 0 && (this.measurements & 2) == 0) {
                this.saveResults(new ImageStatistics(), roi);
                return;
            }
            imageProcessor = new Straightener().straightenLine(this.imp, n);
        } else {
            object = new ProfilePlot(this.imp);
            double[] dArray = ((ProfilePlot)object).getProfile();
            if (dArray == null) {
                return;
            }
            imageProcessor = new FloatProcessor(dArray.length, 1, dArray);
            if (bl) {
                Line line = (Line)roi;
                if ((line.y1 == line.y2 || line.x1 == line.x2) && (double)line.x1 == line.x1d && (double)line.y1 == line.y1d && (double)line.x2 == line.x2d && (double)line.y2 == line.y2d) {
                    imageProcessor.setRoi(0, 0, imageProcessor.getWidth() - 1, 1);
                }
            }
        }
        object = ImageStatistics.getStatistics(imageProcessor, 31, this.imp.getCalibration());
        if (rectangle != null) {
            imageProcessor.setRoi(rectangle);
        }
        this.saveResults((ImageStatistics)object, roi);
    }

    public void saveResults(ImageStatistics imageStatistics, Roi roi) {
        if (this.rt.getColumnHeading(35) == null) {
            this.reset();
        }
        this.incrementCounter();
        int n = this.rt.getCounter();
        if (n <= 20) {
            if (umeans == null) {
                umeans = new float[20];
            }
            Analyzer.umeans[n - 1] = (float)imageStatistics.umean;
        }
        if ((this.measurements & 0x400) != 0) {
            this.rt.addLabel("Label", this.getFileName());
        }
        if ((this.measurements & 1) != 0) {
            this.rt.addValue(0, imageStatistics.area);
        }
        if ((this.measurements & 2) != 0) {
            this.rt.addValue(1, imageStatistics.mean);
        }
        if ((this.measurements & 4) != 0) {
            this.rt.addValue(2, imageStatistics.stdDev);
        }
        if ((this.measurements & 8) != 0) {
            this.rt.addValue(3, imageStatistics.dmode);
        }
        if ((this.measurements & 0x10) != 0) {
            if (showMin) {
                this.rt.addValue(4, imageStatistics.min);
            }
            this.rt.addValue(5, imageStatistics.max);
        }
        if ((this.measurements & 0x20) != 0) {
            this.rt.addValue(6, imageStatistics.xCentroid);
            this.rt.addValue(7, imageStatistics.yCentroid);
        }
        if ((this.measurements & 0x40) != 0) {
            this.rt.addValue(8, imageStatistics.xCenterOfMass);
            this.rt.addValue(9, imageStatistics.yCenterOfMass);
        }
        if ((this.measurements & 0x80) != 0 || (this.measurements & 0x2000) != 0) {
            double d = roi != null ? roi.getLength() : 0.0;
            if ((this.measurements & 0x80) != 0) {
                this.rt.addValue(10, d);
            }
            if ((this.measurements & 0x2000) != 0) {
                boolean bl;
                double d2;
                double d3 = d2 = d == 0.0 ? 0.0 : Math.PI * 4 * (imageStatistics.area / (d * d));
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                this.rt.addValue(18, d2);
                Polygon polygon = null;
                boolean bl2 = bl = roi != null && roi.isArea();
                if (bl) {
                    polygon = roi.getConvexHull();
                }
                this.rt.addValue(33, bl ? imageStatistics.major / imageStatistics.minor : 0.0);
                this.rt.addValue(34, bl ? 4.0 * imageStatistics.area / (Math.PI * imageStatistics.major * imageStatistics.major) : 0.0);
                this.rt.addValue(35, polygon != null ? (double)imageStatistics.pixelCount / this.getArea(polygon) : Double.NaN);
            }
        }
        if ((this.measurements & 0x200) != 0) {
            if (roi != null && roi.isLine()) {
                Rectangle rectangle = roi.getBounds();
                this.rt.addValue(11, (double)rectangle.x);
                this.rt.addValue(12, (double)rectangle.y);
                this.rt.addValue(13, (double)rectangle.width);
                this.rt.addValue(14, (double)rectangle.height);
            } else {
                this.rt.addValue(11, imageStatistics.roiX);
                this.rt.addValue(12, imageStatistics.roiY);
                this.rt.addValue(13, imageStatistics.roiWidth);
                this.rt.addValue(14, imageStatistics.roiHeight);
            }
        }
        if ((this.measurements & 0x800) != 0) {
            this.rt.addValue(15, imageStatistics.major);
            this.rt.addValue(16, imageStatistics.minor);
            this.rt.addValue(17, imageStatistics.angle);
        }
        if ((this.measurements & 0x4000) != 0) {
            double[] dArray;
            boolean bl = true;
            double d = Double.NaN;
            double d4 = Double.NaN;
            double d5 = Double.NaN;
            double d6 = Double.NaN;
            double d7 = Double.NaN;
            if (roi != null && (dArray = roi.getFeretValues()) != null) {
                d = dArray[0];
                d4 = dArray[1];
                d5 = dArray[2];
                d6 = dArray[3];
                d7 = dArray[4];
            }
            this.rt.addValue(19, d);
            this.rt.addValue(29, d6);
            this.rt.addValue(30, d7);
            this.rt.addValue(31, d4);
            this.rt.addValue(32, d5);
        }
        if ((this.measurements & 0x8000) != 0) {
            this.rt.addValue(20, imageStatistics.area * imageStatistics.mean);
            this.rt.addValue(25, (double)imageStatistics.pixelCount * imageStatistics.umean);
        }
        if ((this.measurements & 0x10000) != 0) {
            this.rt.addValue(21, imageStatistics.median);
        }
        if ((this.measurements & 0x20000) != 0) {
            this.rt.addValue(22, imageStatistics.skewness);
        }
        if ((this.measurements & 0x40000) != 0) {
            this.rt.addValue(23, imageStatistics.kurtosis);
        }
        if ((this.measurements & 0x80000) != 0) {
            this.rt.addValue(24, imageStatistics.areaFraction);
        }
        if ((this.measurements & 0x100000) != 0) {
            boolean bl = false;
            if (this.imp != null && (this.imp.isHyperStack() || this.imp.isComposite())) {
                int[] nArray = this.imp.convertIndexToPosition(this.imp.getCurrentSlice());
                if (this.imp.getNChannels() > 1) {
                    int n2 = this.rt.getColumnIndex("Ch");
                    if (n2 < 0 || !this.rt.columnExists(n2)) {
                        bl = true;
                    }
                    this.rt.addValue("Ch", (double)nArray[0]);
                }
                if (this.imp.getNSlices() > 1) {
                    int n3 = this.rt.getColumnIndex("Slice");
                    if (n3 < 0 || !this.rt.columnExists(n3)) {
                        bl = true;
                    }
                    this.rt.addValue("Slice", (double)nArray[1]);
                }
                if (this.imp.getNFrames() > 1) {
                    int n4 = this.rt.getColumnIndex("Frame");
                    if (n4 < 0 || !this.rt.columnExists(n4)) {
                        bl = true;
                    }
                    this.rt.addValue("Frame", (double)nArray[2]);
                }
            } else {
                int n5 = this.rt.getColumnIndex("Slice");
                if (n5 < 0 || !this.rt.columnExists(n5)) {
                    bl = true;
                }
                this.rt.addValue("Slice", this.imp != null ? (double)this.imp.getCurrentSlice() : 1.0);
            }
            if (bl && this.rt == systemRT) {
                this.rt.update(this.measurements, this.imp, roi);
            }
        }
        if (roi != null) {
            if (roi.isLine()) {
                this.rt.addValue("Length", roi.getLength());
                if (roi.getType() == 5) {
                    double d = 0.0;
                    Line line = (Line)roi;
                    d = roi.getAngle(line.x1, line.y1, line.x2, line.y2);
                    this.rt.addValue("Angle", d);
                }
            } else if (roi.getType() == 8) {
                this.rt.addValue("Angle", ((PolygonRoi)roi).getAngle());
            } else if (roi.getType() == 10) {
                this.savePoints(roi);
            }
        }
    }

    final double getArea(Polygon polygon) {
        int n = 0;
        for (int i = 0; i < polygon.npoints; ++i) {
            int n2 = i - 1;
            if (n2 < 0) {
                n2 = polygon.npoints - 1;
            }
            n += (polygon.xpoints[i] + polygon.xpoints[n2]) * (polygon.ypoints[i] - polygon.ypoints[n2]);
        }
        return Math.abs((double)n / 2.0);
    }

    void savePoints(Roi roi) {
        if (this.imp == null) {
            this.rt.addValue("X", 0.0);
            this.rt.addValue("Y", 0.0);
            this.rt.addValue("Slice", 0.0);
            return;
        }
        if ((this.measurements & 1) != 0) {
            this.rt.addValue(0, 0.0);
        }
        Polygon polygon = roi.getPolygon();
        ImageProcessor imageProcessor = this.imp.getProcessor();
        Calibration calibration = this.imp.getCalibration();
        int n = polygon.xpoints[0];
        int n2 = polygon.ypoints[0];
        double d = imageProcessor.getPixelValue(n, n2);
        if (markWidth > 0 && !Toolbar.getMultiPointMode()) {
            imageProcessor.setColor(Toolbar.getForegroundColor());
            imageProcessor.setLineWidth(markWidth);
            imageProcessor.moveTo(n, n2);
            imageProcessor.lineTo(n, n2);
            this.imp.updateAndDraw();
            imageProcessor.setLineWidth(Line.getWidth());
        }
        this.rt.addValue("X", calibration.getX(n));
        this.rt.addValue("Y", calibration.getY(n2, this.imp.getHeight()));
        if (this.imp.isHyperStack() || this.imp.isComposite()) {
            if (this.imp.getNChannels() > 1) {
                this.rt.addValue("Ch", (double)this.imp.getChannel());
            }
            if (this.imp.getNSlices() > 1) {
                this.rt.addValue("Slice", (double)this.imp.getSlice());
            }
            if (this.imp.getNFrames() > 1) {
                this.rt.addValue("Frame", (double)this.imp.getFrame());
            }
        } else {
            this.rt.addValue("Slice", calibration.getZ(this.imp.getCurrentSlice()));
        }
        if (this.imp.getProperty("FHT") != null) {
            double d2 = (double)this.imp.getWidth() / 2.0;
            double d3 = Math.sqrt(((double)n - d2) * ((double)n - d2) + ((double)(n2 = this.imp.getHeight() - n2 - 1) - d2) * ((double)n2 - d2));
            if (d3 < 1.0) {
                d3 = 1.0;
            }
            double d4 = Math.atan2((double)n2 - d2, (double)n - d2);
            if ((d4 = d4 * 180.0 / Math.PI) < 0.0) {
                d4 = 360.0 + d4;
            }
            this.rt.addValue("R", (double)this.imp.getWidth() / d3 * calibration.pixelWidth);
            this.rt.addValue("Theta", d4);
        }
    }

    String getFileName() {
        String string = "";
        if (this.imp != null) {
            String string2;
            Object object;
            if (redirectTarget != 0) {
                object = WindowManager.getImage(redirectTarget);
                if (object == null) {
                    object = redirectImage;
                }
                if (object != null) {
                    string = ((ImagePlus)object).getTitle();
                }
            } else {
                string = this.imp.getTitle();
            }
            object = this.imp.getRoi();
            String string3 = string2 = object != null ? ((Roi)object).getName() : null;
            if (string2 != null) {
                string = string + ":" + string2;
            }
            if (this.imp.getStackSize() > 1) {
                ImageStack imageStack = this.imp.getStack();
                int n = this.imp.getCurrentSlice();
                String string4 = imageStack.getShortSliceLabel(n);
                String string5 = string.equals("") ? "" : ":";
                string = string4 != null && !string4.equals("") ? string + string5 + string4 : string + string5 + n;
            }
        }
        return string;
    }

    public void displayResults() {
        int n = this.rt.getCounter();
        if (n == 1) {
            IJ.setColumnHeadings(this.rt.getColumnHeadings());
        }
        IJ.write(this.rt.getRowAsString(n - 1));
    }

    public void updateHeadings() {
        this.rt.show("Results");
    }

    public String n(double d) {
        String string = (double)Math.round(d) == d ? ResultsTable.d2s(d, 0) : ResultsTable.d2s(d, precision);
        return string + "\t";
    }

    void incrementCounter() {
        if (this.rt == null) {
            this.rt = systemRT;
        }
        this.rt.incrementCounter();
        unsavedMeasurements = true;
    }

    public void summarize() {
        String string;
        TextPanel textPanel;
        this.rt = systemRT;
        if (this.rt.getCounter() == 0) {
            return;
        }
        if (summarized) {
            this.rt.show("Results");
        }
        this.measurements = systemMeasurements;
        this.min = new StringBuffer(100);
        this.max = new StringBuffer(100);
        this.mean = new StringBuffer(100);
        this.sd = new StringBuffer(100);
        this.min.append("Min\t");
        this.max.append("Max\t");
        this.mean.append("Mean\t");
        this.sd.append("SD\t");
        if ((this.measurements & 0x400) != 0) {
            this.min.append("\t");
            this.max.append("\t");
            this.mean.append("\t");
            this.sd.append("\t");
        }
        this.summarizeAreas();
        int n = this.rt.getColumnIndex("Angle");
        if (this.rt.columnExists(n)) {
            this.add2(n);
        }
        if (this.rt.columnExists(n = this.rt.getColumnIndex("Length"))) {
            this.add2(n);
        }
        if ((textPanel = IJ.getTextPanel()) != null && (string = textPanel.getColumnHeadings()).equals("")) {
            IJ.setColumnHeadings(this.rt.getColumnHeadings());
        }
        IJ.write("");
        IJ.write(new String(this.mean));
        IJ.write(new String(this.sd));
        IJ.write(new String(this.min));
        IJ.write(new String(this.max));
        IJ.write("");
        this.mean = null;
        this.sd = null;
        this.min = null;
        this.max = null;
        summarized = true;
    }

    void summarizeAreas() {
        if ((this.measurements & 1) != 0) {
            this.add2(0);
        }
        if ((this.measurements & 2) != 0) {
            this.add2(1);
        }
        if ((this.measurements & 4) != 0) {
            this.add2(2);
        }
        if ((this.measurements & 8) != 0) {
            this.add2(3);
        }
        if ((this.measurements & 0x10) != 0) {
            if (showMin) {
                this.add2(4);
            }
            this.add2(5);
        }
        if ((this.measurements & 0x20) != 0) {
            this.add2(6);
            this.add2(7);
        }
        if ((this.measurements & 0x40) != 0) {
            this.add2(8);
            this.add2(9);
        }
        if ((this.measurements & 0x80) != 0) {
            this.add2(10);
        }
        if ((this.measurements & 0x200) != 0) {
            this.add2(11);
            this.add2(12);
            this.add2(13);
            this.add2(14);
        }
        if ((this.measurements & 0x800) != 0) {
            this.add2(15);
            this.add2(16);
            this.add2(17);
        }
        if ((this.measurements & 0x2000) != 0) {
            this.add2(18);
        }
        if ((this.measurements & 0x4000) != 0) {
            this.add2(19);
        }
        if ((this.measurements & 0x8000) != 0) {
            this.add2(20);
        }
        if ((this.measurements & 0x10000) != 0) {
            this.add2(21);
        }
        if ((this.measurements & 0x20000) != 0) {
            this.add2(22);
        }
        if ((this.measurements & 0x40000) != 0) {
            this.add2(23);
        }
        if ((this.measurements & 0x80000) != 0) {
            this.add2(24);
        }
        if ((this.measurements & 0x100000) != 0) {
            int n = this.rt.getColumnIndex("Ch");
            if (this.rt.columnExists(n)) {
                this.add2(n);
            }
            if (this.rt.columnExists(n = this.rt.getColumnIndex("Slice"))) {
                this.add2(n);
            }
            if (this.rt.columnExists(n = this.rt.getColumnIndex("Frame"))) {
                this.add2(n);
            }
        }
        if ((this.measurements & 0x4000) != 0) {
            this.add2(29);
            this.add2(30);
            this.add2(31);
            this.add2(32);
        }
        if ((this.measurements & 0x2000) != 0) {
            this.add2(33);
            this.add2(34);
            this.add2(35);
        }
    }

    private void add2(int n) {
        float[] fArray;
        float[] fArray2 = fArray = n >= 0 ? this.rt.getColumn(n) : null;
        if (fArray != null) {
            FloatProcessor floatProcessor = new FloatProcessor(fArray.length, 1, fArray, null);
            if (floatProcessor == null) {
                return;
            }
            FloatStatistics floatStatistics = new FloatStatistics(floatProcessor);
            if (floatStatistics == null) {
                return;
            }
            this.mean.append(this.n(floatStatistics.mean));
            this.min.append(this.n(floatStatistics.min));
            this.max.append(this.n(floatStatistics.max));
            this.sd.append(this.n(floatStatistics.stdDev));
        } else {
            this.mean.append("-\t");
            this.min.append("-\t");
            this.max.append("-\t");
            this.sd.append("-\t");
        }
    }

    public static int getCounter() {
        return systemRT.getCounter();
    }

    public static synchronized boolean resetCounter() {
        TextPanel textPanel = IJ.isResultsWindow() ? IJ.getTextPanel() : null;
        int n = systemRT.getCounter();
        int n2 = textPanel != null ? IJ.getTextPanel().getLineCount() : 0;
        ImageJ imageJ = IJ.getInstance();
        boolean bl = IJ.macroRunning() && !switchingModes || Interpreter.isBatchMode();
        switchingModes = false;
        if (n > 0 && n2 > 0 && unsavedMeasurements && !bl && imageJ != null && !imageJ.quitting()) {
            YesNoCancelDialog yesNoCancelDialog = new YesNoCancelDialog((Frame)imageJ, "ImageJ", "Save " + n + " measurements?");
            if (yesNoCancelDialog.cancelPressed()) {
                return false;
            }
            if (yesNoCancelDialog.yesPressed() && !new MeasurementsWriter().save("")) {
                return false;
            }
        }
        umeans = null;
        systemRT.reset();
        unsavedMeasurements = false;
        if (textPanel != null) {
            textPanel.clear();
        }
        summarized = false;
        return true;
    }

    public static void setUnsavedMeasurements(boolean bl) {
        unsavedMeasurements = bl;
    }

    public static int getMeasurements() {
        return systemMeasurements;
    }

    public static void setMeasurements(int n) {
        systemMeasurements = n;
    }

    public static void setMeasurement(int n, boolean bl) {
        systemMeasurements = bl ? (systemMeasurements |= n) : (systemMeasurements &= ~n);
    }

    public static void savePreferences(Properties properties) {
        properties.put(MEASUREMENTS, Integer.toString(systemMeasurements));
        properties.put(MARK_WIDTH, Integer.toString(markWidth));
        properties.put(PRECISION, Integer.toString(precision));
    }

    public static float[] getUMeans() {
        return umeans;
    }

    public static ResultsTable getResultsTable() {
        return systemRT;
    }

    public static int getPrecision() {
        return precision;
    }

    public static void setPrecision(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 9) {
            n = 9;
        }
        precision = n;
    }

    public static int updateY(int n, int n2) {
        if ((systemMeasurements & 0x1000) != 0) {
            n = n2 - n - 1;
        }
        return n;
    }

    public static double updateY(double d, int n) {
        if ((systemMeasurements & 0x1000) != 0) {
            d = (double)n - d - 1.0;
        }
        return d;
    }

    public static void setDefaultHeadings() {
        systemRT.setDefaultHeadings();
    }

    public static void setOption(String string, boolean bl) {
        if (string.indexOf("min") != -1) {
            showMin = bl;
        }
    }

    public static void setResultsTable(ResultsTable resultsTable) {
        if (resultsTable == null) {
            resultsTable = new ResultsTable();
        }
        systemRT = resultsTable;
    }

    static {
        darkBlue = new Color(0, 0, 160);
        systemMeasurements = Prefs.getInt(MEASUREMENTS, 19);
        markWidth = Prefs.getInt(MARK_WIDTH, 0);
        precision = Prefs.getInt(PRECISION, 3);
        umeans = new float[20];
        systemRT = new ResultsTable();
        redirectTitle = "";
        showMin = true;
    }
}

