/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.plugin.DICOM_Sorter;
import ij.plugin.FolderOpenerDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.awt.image.ColorModel;
import java.io.File;

public class FolderOpener
implements PlugIn {
    private static String[] excludedTypes = new String[]{".txt", ".lut", ".roi", ".pty", ".hdr", ".java", ".ijm", ".py", ".js", ".bsh"};
    private static boolean convertToGrayscale;
    private static boolean convertToRGB;
    private static boolean sortFileNames;
    private static boolean virtualStack;
    private double scale = 100.0;
    private int n;
    private int start;
    private int increment;
    private String filter;
    private boolean isRegex;
    private FileInfo fi;
    private String info1;

    public void run(String string) {
        boolean bl;
        Calibration calibration;
        double d;
        double d2;
        ImageStack imageStack;
        String string2;
        String string3;
        block58: {
            int n;
            OpenDialog openDialog = new OpenDialog("Open Image Sequence...", string);
            string3 = openDialog.getDirectory();
            String string4 = openDialog.getFileName();
            if (string4 == null) {
                return;
            }
            String[] stringArray = new File(string3).list();
            if (stringArray == null) {
                return;
            }
            string2 = string3;
            if (string2.endsWith(File.separator) || string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if ((n = string2.lastIndexOf(File.separatorChar)) != -1) {
                string2 = string2.substring(n + 1);
            }
            if (string2.endsWith(":")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            IJ.register(FolderOpener.class);
            stringArray = this.trimFileList(stringArray);
            if (stringArray == null) {
                return;
            }
            if (IJ.debugMode) {
                IJ.log("FolderOpener: " + string3 + " (" + stringArray.length + " files)");
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            imageStack = null;
            d2 = Double.MAX_VALUE;
            d = -1.7976931348623157E308;
            calibration = null;
            bl = true;
            IJ.resetEscape();
            try {
                int n6;
                String[] stringArray2;
                int n7;
                for (n7 = 0; n7 < stringArray.length; ++n7) {
                    IJ.redirectErrorMessages();
                    stringArray2 = new Opener().openImage(string3, stringArray[n7]);
                    if (stringArray2 == null) continue;
                    n2 = stringArray2.getWidth();
                    n3 = stringArray2.getHeight();
                    n5 = stringArray2.getBitDepth();
                    this.fi = stringArray2.getOriginalFileInfo();
                    if (this.showDialog((ImagePlus)stringArray2, stringArray)) break;
                    return;
                }
                if (n2 == 0) {
                    IJ.error("Import Sequence", "This folder does not appear to contain any TIFF,\nJPEG, BMP, DICOM, GIF, FITS or PGM files.");
                    return;
                }
                if (this.filter != null && (this.filter.equals("") || this.filter.equals("*"))) {
                    this.filter = null;
                }
                if (this.filter != null) {
                    n7 = 0;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (this.isRegex && stringArray[i].matches(this.filter)) {
                            ++n7;
                            continue;
                        }
                        if (stringArray[i].indexOf(this.filter) >= 0) {
                            ++n7;
                            continue;
                        }
                        stringArray[i] = null;
                    }
                    if (n7 == 0) {
                        if (this.isRegex) {
                            IJ.error("Import Sequence", "None of the file names match the regular expression.");
                        } else {
                            IJ.error("Import Sequence", "None of the " + stringArray.length + " files contain\n the string '" + this.filter + "' in their name.");
                        }
                        return;
                    }
                    stringArray2 = new String[n7];
                    int n8 = 0;
                    for (n6 = 0; n6 < stringArray.length; ++n6) {
                        if (stringArray[n6] == null) continue;
                        stringArray2[n8++] = stringArray[n6];
                    }
                    stringArray = stringArray2;
                }
                if (sortFileNames) {
                    stringArray = this.sortFileList(stringArray);
                }
                if (this.n < 1) {
                    this.n = stringArray.length;
                }
                if (this.start < 1 || this.start > stringArray.length) {
                    this.start = 1;
                }
                if (this.start + this.n - 1 > stringArray.length) {
                    this.n = stringArray.length - this.start + 1;
                }
                n7 = 0;
                int n9 = 0;
                ImagePlus imagePlus = null;
                for (n6 = this.start - 1; n6 < stringArray.length; ++n6) {
                    Object object;
                    Object object2;
                    if (n9++ % this.increment != 0) continue;
                    Opener opener = new Opener();
                    opener.setSilentMode(true);
                    IJ.redirectErrorMessages();
                    if (!virtualStack || imageStack == null) {
                        imagePlus = opener.openImage(string3, stringArray[n6]);
                    }
                    if (imagePlus != null && imageStack == null) {
                        n2 = imagePlus.getWidth();
                        n3 = imagePlus.getHeight();
                        n4 = imagePlus.getStackSize();
                        n5 = imagePlus.getBitDepth();
                        calibration = imagePlus.getCalibration();
                        if (convertToRGB) {
                            n5 = 24;
                        }
                        if (convertToGrayscale) {
                            n5 = 8;
                        }
                        object2 = imagePlus.getProcessor().getColorModel();
                        if (virtualStack) {
                            imageStack = new VirtualStack(n2, n3, (ColorModel)object2, string3);
                            ((VirtualStack)imageStack).setBitDepth(n5);
                        } else {
                            imageStack = this.scale < 100.0 ? new ImageStack((int)((double)n2 * this.scale / 100.0), (int)((double)n3 * this.scale / 100.0), (ColorModel)object2) : new ImageStack(n2, n3, (ColorModel)object2);
                        }
                        this.info1 = (String)imagePlus.getProperty("Info");
                    }
                    if (imagePlus == null) continue;
                    if (imagePlus.getWidth() != n2 || imagePlus.getHeight() != n3) {
                        IJ.log(stringArray[n6] + ": wrong size; " + n2 + "x" + n3 + " expected, " + imagePlus.getWidth() + "x" + imagePlus.getHeight() + " found");
                        continue;
                    }
                    object2 = imagePlus.getTitle();
                    if (n4 == 1 && (object = (String)imagePlus.getProperty("Info")) != null) {
                        object2 = (String)object2 + "\n" + (String)object;
                    }
                    if (imagePlus.getCalibration().pixelWidth != calibration.pixelWidth) {
                        bl = false;
                    }
                    object = imagePlus.getStack();
                    for (int i = 1; i <= ((ImageStack)object).getSize(); ++i) {
                        ImageProcessor imageProcessor = ((ImageStack)object).getProcessor(i);
                        int n10 = imagePlus.getBitDepth();
                        if (!virtualStack) {
                            if (convertToRGB) {
                                imageProcessor = imageProcessor.convertToRGB();
                                n10 = 24;
                            } else if (convertToGrayscale) {
                                imageProcessor = imageProcessor.convertToByte(true);
                                n10 = 8;
                            }
                            if (n10 != n5) {
                                if (n5 == 8) {
                                    imageProcessor = imageProcessor.convertToByte(true);
                                    n10 = 8;
                                } else if (n5 == 24) {
                                    imageProcessor = imageProcessor.convertToRGB();
                                    n10 = 24;
                                }
                            }
                            if (n10 != n5) {
                                IJ.log(stringArray[n6] + ": wrong bit depth; " + n5 + " expected, " + n10 + " found");
                                break;
                            }
                        }
                        if (i == 1) {
                            ++n7;
                        }
                        IJ.showStatus(n7 + "/" + this.n);
                        IJ.showProgress(n7, this.n);
                        if (this.scale < 100.0) {
                            imageProcessor = imageProcessor.resize((int)((double)n2 * this.scale / 100.0), (int)((double)n3 * this.scale / 100.0));
                        }
                        if (imageProcessor.getMin() < d2) {
                            d2 = imageProcessor.getMin();
                        }
                        if (imageProcessor.getMax() > d) {
                            d = imageProcessor.getMax();
                        }
                        Object object3 = object2;
                        if (virtualStack) {
                            if (i != 1) continue;
                            ((VirtualStack)imageStack).addSlice(stringArray[n6]);
                            continue;
                        }
                        imageStack.addSlice((String)object3, imageProcessor);
                    }
                    if (n7 < this.n) {
                        if (!IJ.escapePressed()) continue;
                        IJ.beep();
                    }
                    break;
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                IJ.outOfMemory("FolderOpener");
                if (imageStack == null) break block58;
                imageStack.trim();
            }
        }
        if (imageStack != null && imageStack.getSize() > 0) {
            ImagePlus imagePlus;
            if (this.info1 != null && this.info1.lastIndexOf("7FE0,0010") > 0) {
                imageStack = new DICOM_Sorter().sort(imageStack);
            }
            if ((imagePlus = new ImagePlus(string2, imageStack)).getType() == 1 || imagePlus.getType() == 2) {
                imagePlus.getProcessor().setMinAndMax(d2, d);
            }
            if (this.fi == null) {
                this.fi = new FileInfo();
            }
            this.fi.fileFormat = 0;
            this.fi.fileName = "";
            this.fi.directory = string3;
            imagePlus.setFileInfo(this.fi);
            if (bl) {
                if (calibration.pixelWidth != 1.0 && calibration.pixelDepth == 1.0) {
                    calibration.pixelDepth = calibration.pixelWidth;
                }
                if (calibration.pixelWidth <= 1.0E-4 && calibration.getUnit().equals("cm")) {
                    calibration.pixelWidth *= 10000.0;
                    calibration.pixelHeight *= 10000.0;
                    calibration.pixelDepth *= 10000.0;
                    calibration.setUnit("um");
                }
                imagePlus.setCalibration(calibration);
            }
            if (imagePlus.getStackSize() == 1 && this.info1 != null) {
                imagePlus.setProperty("Info", this.info1);
            }
            imagePlus.show();
        }
        IJ.showProgress(1.0);
    }

    boolean showDialog(ImagePlus imagePlus, String[] stringArray) {
        int n = stringArray.length;
        FolderOpenerDialog folderOpenerDialog = new FolderOpenerDialog("Sequence Options", imagePlus, stringArray);
        folderOpenerDialog.addNumericField("Number of images:", n, 0);
        folderOpenerDialog.addNumericField("Starting image:", 1.0, 0);
        folderOpenerDialog.addNumericField("Increment:", 1.0, 0);
        folderOpenerDialog.addNumericField("Scale images:", this.scale, 0, 4, "%");
        folderOpenerDialog.addStringField("File name contains:", "", 10);
        folderOpenerDialog.addStringField("or enter pattern:", "", 10);
        folderOpenerDialog.addCheckbox("Convert to 8-bit Grayscale", convertToGrayscale);
        folderOpenerDialog.addCheckbox("Convert_to_RGB", convertToRGB);
        folderOpenerDialog.addCheckbox("Sort names numerically", sortFileNames);
        folderOpenerDialog.addCheckbox("Use virtual stack", virtualStack);
        folderOpenerDialog.addMessage("10000 x 10000 x 1000 (100.3MB)");
        folderOpenerDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/file.html#seq1");
        folderOpenerDialog.showDialog();
        if (folderOpenerDialog.wasCanceled()) {
            return false;
        }
        this.n = (int)folderOpenerDialog.getNextNumber();
        this.start = (int)folderOpenerDialog.getNextNumber();
        this.increment = (int)folderOpenerDialog.getNextNumber();
        if (this.increment < 1) {
            this.increment = 1;
        }
        this.scale = folderOpenerDialog.getNextNumber();
        if (this.scale < 5.0) {
            this.scale = 5.0;
        }
        if (this.scale > 100.0) {
            this.scale = 100.0;
        }
        this.filter = folderOpenerDialog.getNextString();
        String string = folderOpenerDialog.getNextString();
        if (!string.equals("")) {
            this.filter = string;
            this.isRegex = true;
        }
        convertToGrayscale = folderOpenerDialog.getNextBoolean();
        convertToRGB = folderOpenerDialog.getNextBoolean();
        sortFileNames = folderOpenerDialog.getNextBoolean();
        virtualStack = folderOpenerDialog.getNextBoolean();
        if (virtualStack) {
            this.scale = 100.0;
        }
        if (convertToGrayscale && convertToRGB) {
            IJ.error("Cannot convert to grayscale and RGB at the same time.");
            return false;
        }
        return true;
    }

    public String[] trimFileList(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith(".") || string.equals("Thumbs.db") || FolderOpener.excludedFileType(string)) {
                stringArray[i] = null;
                continue;
            }
            ++n;
        }
        if (n == 0) {
            return null;
        }
        String[] stringArray2 = stringArray;
        if (n < stringArray.length) {
            stringArray2 = new String[n];
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringArray2[n2++] = stringArray[i];
            }
        }
        return stringArray2;
    }

    public static boolean excludedFileType(String string) {
        if (string == null) {
            return true;
        }
        for (int i = 0; i < excludedTypes.length; ++i) {
            if (!string.endsWith(excludedTypes[i])) continue;
            return true;
        }
        return false;
    }

    public String[] sortFileList(String[] stringArray) {
        int n;
        int n2;
        int n3 = stringArray.length;
        boolean bl = true;
        int n4 = stringArray[0].length();
        for (n2 = 0; n2 < n3; ++n2) {
            if (stringArray[n2].length() == n4) continue;
            bl = false;
            break;
        }
        if (bl) {
            StringSorter.sort(stringArray);
            return stringArray;
        }
        n2 = 15;
        String[] stringArray2 = null;
        for (n = 0; n < n3; ++n) {
            int n5 = stringArray[n].length();
            String string = "";
            for (int i = 0; i < n5; ++i) {
                char c = stringArray[n].charAt(i);
                if (c < '0' || c > '9') continue;
                string = string + c;
            }
            if (stringArray2 == null) {
                stringArray2 = new String[n3];
            }
            if (string.length() == 0) {
                string = "aaaaaa";
            }
            string = "000000000000000" + string;
            string = string.substring(string.length() - n2);
            stringArray2[n] = string + stringArray[n];
        }
        if (stringArray2 != null) {
            StringSorter.sort(stringArray2);
            for (n = 0; n < n3; ++n) {
                stringArray2[n] = stringArray2[n].substring(n2);
            }
            return stringArray2;
        }
        StringSorter.sort(stringArray);
        return stringArray;
    }

    static {
        sortFileNames = true;
    }
}

