/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.macro.MacroConstants;
import ij.macro.Program;
import ij.macro.Symbol;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class Tokenizer
implements MacroConstants {
    private StreamTokenizer st;
    private int token;
    private String tokenString;
    private double tokenValue;
    private Program pgm;
    private int lineNumber;

    public Program tokenize(String string) {
        this.st = new StreamTokenizer(new StringReader(string));
        this.st.ordinaryChar(45);
        this.st.ordinaryChar(47);
        this.st.ordinaryChar(46);
        this.st.wordChars(95, 95);
        this.st.whitespaceChars(128, 255);
        this.st.slashStarComments(true);
        this.st.slashSlashComments(true);
        this.pgm = new Program();
        do {
            this.getToken();
            this.addToken();
        } while (this.token != 128);
        if (this.pgm.hasFunctions) {
            this.addUserFunctions();
        }
        return this.pgm;
    }

    final void getToken() {
        try {
            this.token = this.st.nextToken();
            this.lineNumber = this.st.lineno();
            String string = null;
            switch (this.st.ttype) {
                case -1: {
                    string = "EOF";
                    this.token = 128;
                    break;
                }
                case -3: {
                    string = this.st.sval;
                    this.token = 129;
                    break;
                }
                case -2: {
                    string = "" + this.st.nval;
                    this.tokenValue = this.st.nval;
                    if (this.tokenValue == 0.0) {
                        this.tokenValue = this.getHexConstant();
                    } else if (this.tryScientificNotation()) {
                        string = string + this.st.sval;
                    }
                    this.token = 130;
                    break;
                }
                case 34: 
                case 39: {
                    string = "" + this.st.sval;
                    this.token = 133;
                    break;
                }
                case 43: {
                    int n = this.st.nextToken();
                    if (n == 43) {
                        this.token = 1;
                        break;
                    }
                    if (n == 61) {
                        this.token = 9;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 45: {
                    int n = this.st.nextToken();
                    if (n == 45) {
                        this.token = 2;
                        break;
                    }
                    if (n == 61) {
                        this.token = 10;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 42: {
                    int n = this.st.nextToken();
                    if (n == 61) {
                        this.token = 11;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 47: {
                    int n = this.st.nextToken();
                    if (n == 61) {
                        this.token = 12;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 61: {
                    int n = this.st.nextToken();
                    if (n == 61) {
                        this.token = 3;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 33: {
                    int n = this.st.nextToken();
                    if (n == 61) {
                        this.token = 4;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 62: {
                    int n = this.st.nextToken();
                    if (n == 61) {
                        this.token = 6;
                        break;
                    }
                    if (n == 62) {
                        this.token = 15;
                        break;
                    }
                    this.st.pushBack();
                    this.token = 5;
                    break;
                }
                case 60: {
                    int n = this.st.nextToken();
                    if (n == 61) {
                        this.token = 8;
                        break;
                    }
                    if (n == 60) {
                        this.token = 16;
                        break;
                    }
                    this.st.pushBack();
                    this.token = 7;
                    break;
                }
                case 38: {
                    int n = this.st.nextToken();
                    if (n == 38) {
                        this.token = 13;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
                case 124: {
                    int n = this.st.nextToken();
                    if (n == 124) {
                        this.token = 14;
                        break;
                    }
                    this.st.pushBack();
                    break;
                }
            }
            this.tokenString = string;
        }
        catch (Exception exception) {
            return;
        }
    }

    final void addToken() {
        int n = this.token;
        switch (this.token) {
            case 129: {
                Symbol symbol = this.pgm.lookupWord(this.tokenString);
                if (symbol != null) {
                    int n2 = symbol.getFunctionType();
                    if (n2 == 0) {
                        n = symbol.type;
                        switch (n) {
                            case 207: {
                                this.pgm.hasFunctions = true;
                                break;
                            }
                            case 201: {
                                this.pgm.hasVars = true;
                                break;
                            }
                            case 200: {
                                ++this.pgm.macroCount;
                            }
                        }
                    } else {
                        n = n2;
                    }
                    n += this.pgm.symTabLoc << 12;
                    break;
                }
                this.pgm.addSymbol(new Symbol(this.token, this.tokenString));
                n += this.pgm.stLoc << 12;
                break;
            }
            case 133: {
                this.pgm.addSymbol(new Symbol(this.token, this.tokenString));
                n += this.pgm.stLoc << 12;
                break;
            }
            case 130: {
                this.pgm.addSymbol(new Symbol(this.tokenValue));
                n += this.pgm.stLoc << 12;
                break;
            }
        }
        this.pgm.addToken(n, this.lineNumber);
    }

    double getHexConstant() {
        try {
            this.token = this.st.nextToken();
        }
        catch (Exception exception) {
            return 0.0;
        }
        if (this.st.ttype != -3) {
            this.st.pushBack();
            return 0.0;
        }
        if (!this.st.sval.startsWith("x")) {
            this.st.pushBack();
            return 0.0;
        }
        String string = this.st.sval.substring(1, this.st.sval.length());
        double d = 0.0;
        try {
            d = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            this.st.pushBack();
            d = 0.0;
        }
        return d;
    }

    boolean tryScientificNotation() {
        String string = "" + this.tokenValue;
        try {
            int n = this.st.nextToken();
            String string2 = this.st.sval;
            if (this.st.ttype == -3 && (string2.startsWith("e") || string2.startsWith("E"))) {
                if (string2.equalsIgnoreCase("e")) {
                    n = this.st.nextToken();
                    if (n == 45) {
                        string2 = string2 + "-";
                    } else if (n != 43) {
                        throw new Exception();
                    }
                    if (this.st.nextToken() != -2) {
                        throw new Exception();
                    }
                    string2 = string2 + this.st.nval;
                }
                if (string2.endsWith(".0")) {
                    string2 = string2.substring(0, string2.length() - 2);
                }
                this.tokenValue = Double.parseDouble(string + string2);
                return true;
            }
            this.st.pushBack();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    void addUserFunctions() {
        int[] nArray = this.pgm.getCode();
        block0: for (int i = 0; i < nArray.length; ++i) {
            this.token = nArray[i] & 0xFFF;
            if (this.token == 207) {
                int n;
                int n2 = nArray[i + 1] & 0xFFF;
                if (n2 != 129 && (n2 < 134 || n2 > 137)) continue;
                int n3 = n = nArray[i + 1] >> 12;
                if (n2 != 129) {
                    this.pgm.addSymbol(new Symbol(129, this.pgm.getSymbolTable()[n3].str));
                    n = this.pgm.stLoc;
                    nArray[i + 1] = 129 + (n << 12);
                }
                Symbol symbol = this.pgm.getSymbolTable()[n];
                symbol.type = 138;
                symbol.value = i + 1;
                for (int j = 0; j < nArray.length; ++j) {
                    this.token = nArray[j] & 0xFFF;
                    if ((this.token == 129 || this.token >= 134 && this.token <= 137) && nArray[j] >> 12 == n3 && (j == 0 || (nArray[j - 1] & 0xFFF) != 207)) {
                        nArray[j] = 138;
                        int n4 = j;
                        nArray[n4] = nArray[n4] + (n << 12);
                        continue;
                    }
                    if (this.token == 128) continue block0;
                }
                continue;
            }
            if (this.token == 128) break;
        }
    }
}

