/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.Rserve.protocol;

import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPExpressionVector;
import org.rosuda.REngine.REXPFactor;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPLanguage;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPNull;
import org.rosuda.REngine.REXPRaw;
import org.rosuda.REngine.REXPS4;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPSymbol;
import org.rosuda.REngine.REXPUnknown;
import org.rosuda.REngine.RList;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.protocol.RTalk;

public class REXPFactory {
    public static final int XT_NULL = 0;
    public static final int XT_INT = 1;
    public static final int XT_DOUBLE = 2;
    public static final int XT_STR = 3;
    public static final int XT_LANG = 4;
    public static final int XT_SYM = 5;
    public static final int XT_BOOL = 6;
    public static final int XT_S4 = 7;
    public static final int XT_VECTOR = 16;
    public static final int XT_LIST = 17;
    public static final int XT_CLOS = 18;
    public static final int XT_SYMNAME = 19;
    public static final int XT_LIST_NOTAG = 20;
    public static final int XT_LIST_TAG = 21;
    public static final int XT_LANG_NOTAG = 22;
    public static final int XT_LANG_TAG = 23;
    public static final int XT_VECTOR_EXP = 26;
    public static final int XT_VECTOR_STR = 27;
    public static final int XT_ARRAY_INT = 32;
    public static final int XT_ARRAY_DOUBLE = 33;
    public static final int XT_ARRAY_STR = 34;
    public static final int XT_ARRAY_BOOL_UA = 35;
    public static final int XT_ARRAY_BOOL = 36;
    public static final int XT_RAW = 37;
    public static final int XT_ARRAY_CPLX = 38;
    public static final int XT_UNKNOWN = 48;
    public static final int XT_FACTOR = 127;
    private static final int XT_HAS_ATTR = 128;
    int type;
    REXPFactory attr;
    REXP cont;
    RList rootList;

    public REXP getREXP() {
        return this.cont;
    }

    public REXPList getAttr() {
        return this.attr == null ? null : (REXPList)this.attr.cont;
    }

    public REXPFactory() {
    }

    public REXPFactory(REXP rEXP) throws REXPMismatchException {
        if (rEXP == null) {
            rEXP = new REXPNull();
        }
        REXPList rEXPList = rEXP._attr();
        this.cont = rEXP;
        if (rEXPList != null) {
            this.attr = new REXPFactory(rEXPList);
        }
        if (rEXP instanceof REXPNull) {
            this.type = 0;
        } else if (rEXP instanceof REXPList) {
            RList rList = rEXP.asList();
            int n = this.type = rList.isNamed() ? 21 : 20;
            if (rEXP instanceof REXPLanguage) {
                this.type = this.type == 21 ? 23 : 22;
            }
        } else if (rEXP instanceof REXPGenericVector) {
            this.type = 16;
        } else if (rEXP instanceof REXPS4) {
            this.type = 7;
        } else if (rEXP instanceof REXPInteger) {
            this.type = 32;
        } else if (rEXP instanceof REXPDouble) {
            this.type = 33;
        } else if (rEXP instanceof REXPString) {
            this.type = 34;
        } else if (rEXP instanceof REXPSymbol) {
            this.type = 19;
        } else if (rEXP instanceof REXPRaw) {
            this.type = 37;
        } else if (rEXP instanceof REXPLogical) {
            this.type = 36;
        } else {
            System.err.println("*** REXPFactory unable to interpret " + rEXP);
        }
    }

    public int parseREXP(byte[] byArray, int n) throws REXPMismatchException {
        int n2 = RTalk.getLen(byArray, n);
        boolean bl = (byArray[n] & 0x80) != 0;
        boolean bl2 = (byArray[n] & 0x40) != 0;
        int n3 = byArray[n] & 0x3F;
        if (bl2) {
            n += 4;
        }
        int n4 = (n += 4) + n2;
        this.type = n3;
        this.attr = new REXPFactory();
        this.cont = null;
        if (bl) {
            n = this.attr.parseREXP(byArray, n);
        }
        if (n3 == 0) {
            this.cont = new REXPNull(this.getAttr());
            return n;
        }
        if (n3 == 2) {
            long l = RTalk.getLong(byArray, n);
            double[] dArray = new double[]{Double.longBitsToDouble(l)};
            if ((n += 8) != n4) {
                System.err.println("Warning: double SEXP size mismatch\n");
                n = n4;
            }
            this.cont = new REXPDouble(dArray, this.getAttr());
            return n;
        }
        if (n3 == 33) {
            int n5 = (n4 - n) / 8;
            int n6 = 0;
            double[] dArray = new double[n5];
            while (n < n4) {
                dArray[n6] = Double.longBitsToDouble(RTalk.getLong(byArray, n));
                n += 8;
                ++n6;
            }
            if (n != n4) {
                System.err.println("Warning: double array SEXP size mismatch\n");
                n = n4;
            }
            this.cont = new REXPDouble(dArray, this.getAttr());
            return n;
        }
        if (n3 == 6) {
            byte[] byArray2 = new byte[]{byArray[n]};
            if (byArray2[0] != 0 && byArray2[0] != 1) {
                byArray2[0] = -128;
            }
            this.cont = new REXPLogical(byArray2, this.getAttr());
            if (++n != n4) {
                if (n4 != n + 3) {
                    System.err.println("Warning: bool SEXP size mismatch\n");
                }
                n = n4;
            }
            return n;
        }
        if (n3 == 35) {
            int n7 = n4 - n;
            boolean bl3 = false;
            byte[] byArray3 = new byte[n7];
            System.arraycopy(byArray, n, byArray3, 0, n4 - n);
            n = n4;
            for (int i = 0; i < byArray3.length; ++i) {
                if (byArray3[i] == 0 || byArray3[i] == 1) continue;
                byArray3[i] = -128;
            }
            this.cont = new REXPLogical(byArray3, this.getAttr());
            return n;
        }
        if (n3 == 36) {
            int n8 = RTalk.getInt(byArray, n);
            byte[] byArray4 = new byte[n8];
            System.arraycopy(byArray, n += 4, byArray4, 0, n8);
            for (int i = 0; i < byArray4.length; ++i) {
                if (byArray4[i] == 0 || byArray4[i] == 1) continue;
                byArray4[i] = -128;
            }
            n = n4;
            this.cont = new REXPLogical(byArray4, this.getAttr());
            return n;
        }
        if (n3 == 1) {
            int[] nArray = new int[]{RTalk.getInt(byArray, n)};
            this.cont = new REXPInteger(nArray, this.getAttr());
            if ((n += 4) != n4) {
                System.err.println("Warning: int SEXP size mismatch\n");
                n = n4;
            }
            return n;
        }
        if (n3 == 32) {
            int n9 = (n4 - n) / 4;
            int n10 = 0;
            int[] nArray = new int[n9];
            while (n < n4) {
                nArray[n10] = RTalk.getInt(byArray, n);
                n += 4;
                ++n10;
            }
            if (n != n4) {
                System.err.println("Warning: int array SEXP size mismatch\n");
                n = n4;
            }
            this.cont = null;
            try {
                if (this.getAttr() != null) {
                    REXP rEXP = this.getAttr().asList().at("class");
                    REXP rEXP2 = this.getAttr().asList().at("levels");
                    if (rEXP != null && rEXP2 != null && rEXP.asString().equals("factor")) {
                        this.cont = new REXPFactor(nArray, rEXP2.asStrings(), this.getAttr());
                        n3 = 127;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.cont == null) {
                this.cont = new REXPInteger(nArray, this.getAttr());
            }
            return n;
        }
        if (n3 == 37) {
            int n11 = RTalk.getInt(byArray, n);
            byte[] byArray5 = new byte[n11];
            System.arraycopy(byArray, n += 4, byArray5, 0, n11);
            n = n4;
            this.cont = new REXPRaw(byArray5, this.getAttr());
            return n;
        }
        if (n3 == 20 || n3 == 21 || n3 == 22 || n3 == 23) {
            REXPFactory rEXPFactory = new REXPFactory();
            REXPFactory rEXPFactory2 = new REXPFactory();
            RList rList = new RList();
            while (n < n4) {
                String string = null;
                n = rEXPFactory.parseREXP(byArray, n);
                if (n3 == 21 || n3 == 23) {
                    n = rEXPFactory2.parseREXP(byArray, n);
                    if (rEXPFactory2.cont.isSymbol() || rEXPFactory2.cont.isString()) {
                        string = rEXPFactory2.cont.asString();
                    }
                }
                if (string == null) {
                    rList.add(rEXPFactory.cont);
                    continue;
                }
                rList.put(string, rEXPFactory.cont);
            }
            REXP rEXP = this.cont = n3 == 22 || n3 == 23 ? new REXPLanguage(rList, this.getAttr()) : new REXPList(rList, this.getAttr());
            if (n != n4) {
                System.err.println("Warning: int list SEXP size mismatch\n");
                n = n4;
            }
            return n;
        }
        if (n3 == 17 || n3 == 4) {
            boolean bl4 = false;
            if (this.rootList == null) {
                this.rootList = new RList();
                bl4 = true;
            }
            REXPFactory rEXPFactory = new REXPFactory();
            REXPFactory rEXPFactory3 = new REXPFactory();
            n = rEXPFactory.parseREXP(byArray, n);
            int n12 = this.rootList.size();
            this.rootList.add(rEXPFactory.cont);
            n = this.parseREXP(byArray, n);
            if (n < n4) {
                n = rEXPFactory3.parseREXP(byArray, n);
                if (rEXPFactory3.cont != null && (rEXPFactory3.cont.isString() || rEXPFactory3.cont.isSymbol())) {
                    this.rootList.setKeyAt(n12, rEXPFactory3.cont.asString());
                }
            }
            if (bl4) {
                this.cont = n3 == 17 ? new REXPList(this.rootList, this.getAttr()) : new REXPLanguage(this.rootList, this.getAttr());
                this.rootList = null;
            }
            return n;
        }
        if (n3 == 16 || n3 == 26) {
            Object object;
            Vector<REXP> vector = new Vector<REXP>();
            while (n < n4) {
                object = new REXPFactory();
                n = ((REXPFactory)object).parseREXP(byArray, n);
                vector.addElement(((REXPFactory)object).cont);
            }
            if (n != n4) {
                System.err.println("Warning: int vector SEXP size mismatch\n");
                n = n4;
            }
            if (this.getAttr() != null && this.getAttr().asList().at("names") != null) {
                RList rList;
                object = this.getAttr().asList().at("names");
                String[] stringArray = null;
                if (((REXP)object).isString()) {
                    stringArray = ((REXP)object).asStrings();
                } else if (((REXP)object).isVector()) {
                    rList = ((REXP)object).asList();
                    Object[] objectArray = rList.toArray();
                    stringArray = new String[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringArray[i] = ((REXP)objectArray[i]).asString();
                    }
                }
                rList = new RList(vector, stringArray);
                this.cont = n3 == 26 ? new REXPExpressionVector(rList, this.getAttr()) : new REXPGenericVector(rList, this.getAttr());
            } else {
                this.cont = n3 == 26 ? new REXPExpressionVector(new RList(vector), this.getAttr()) : new REXPGenericVector(new RList(vector), this.getAttr());
            }
            return n;
        }
        if (n3 == 34) {
            int n13 = 0;
            int n14 = n;
            while (n14 < n4) {
                if (byArray[n14++] != 0) continue;
                ++n13;
            }
            String[] stringArray = new String[n13];
            if (n13 > 0) {
                n13 = 0;
                n14 = n;
                while (n < n4) {
                    if (byArray[n] == 0) {
                        try {
                            stringArray[n13] = byArray[n14] == -1 ? (byArray[n14 + 1] == 0 ? null : new String(byArray, n14 + 1, n - n14 - 1, RConnection.transferCharset)) : new String(byArray, n14, n - n14, RConnection.transferCharset);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            stringArray[n13] = "";
                        }
                        ++n13;
                        n14 = n + 1;
                    }
                    ++n;
                }
            }
            this.cont = new REXPString(stringArray, this.getAttr());
            return n;
        }
        if (n3 == 27) {
            String[] stringArray;
            Vector<String> vector = new Vector<String>();
            while (n < n4) {
                stringArray = new REXPFactory();
                n = stringArray.parseREXP(byArray, n);
                vector.addElement(stringArray.cont.asString());
            }
            if (n != n4) {
                System.err.println("Warning: int vector SEXP size mismatch\n");
                n = n4;
            }
            stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.get(i);
            }
            this.cont = new REXPString(stringArray, this.getAttr());
            return n;
        }
        if (n3 == 3 || n3 == 19) {
            int n15;
            for (n15 = n; byArray[n15] != 0 && n15 < n4; ++n15) {
            }
            try {
                this.cont = n3 == 3 ? new REXPString(new String[]{new String(byArray, n, n15 - n, RConnection.transferCharset)}, this.getAttr()) : new REXPSymbol(new String(byArray, n, n15 - n, RConnection.transferCharset));
            }
            catch (Exception exception) {
                System.err.println("unable to convert string\n");
                this.cont = null;
            }
            n = n4;
            return n;
        }
        if (n3 == 5) {
            REXPFactory rEXPFactory = new REXPFactory();
            n = rEXPFactory.parseREXP(byArray, n);
            this.cont = new REXPSymbol(rEXPFactory.getREXP().asString());
            n = n4;
            return n;
        }
        if (n3 == 18) {
            n = n4;
            return n;
        }
        if (n3 == 48) {
            this.cont = new REXPUnknown(RTalk.getInt(byArray, n), this.getAttr());
            n = n4;
            return n;
        }
        if (n3 == 7) {
            this.cont = new REXPS4(this.getAttr());
            n = n4;
            return n;
        }
        this.cont = null;
        n = n4;
        System.err.println("unhandled type: " + n3);
        return n;
    }

    public int getBinaryLength() throws REXPMismatchException {
        int n = 0;
        int n2 = this.type;
        if (this.type == 17 || this.type == 21 || this.type == 20) {
            int n3 = n2 = this.cont.asList() != null && this.cont.asList().isNamed() ? 21 : 20;
        }
        if (this.type == 27) {
            n2 = 34;
        }
        boolean bl = false;
        REXPList rEXPList = this.getAttr();
        RList rList = null;
        if (rEXPList != null) {
            rList = rEXPList.asList();
        }
        if (rList != null && rList.size() > 0) {
            bl = true;
        }
        if (bl) {
            n += this.attr.getBinaryLength();
        }
        switch (n2) {
            case 0: 
            case 7: {
                break;
            }
            case 1: {
                n += 4;
                break;
            }
            case 2: {
                n += 8;
                break;
            }
            case 37: {
                if (((n += 4 + this.cont.asBytes().length) & 3) <= 0) break;
                n = n - (n & 3) + 4;
                break;
            }
            case 3: 
            case 19: {
                if (((n += this.cont == null ? 1 : this.cont.asString().length() + 1) & 3) <= 0) break;
                n = n - (n & 3) + 4;
                break;
            }
            case 32: {
                n += this.cont.asIntegers().length * 4;
                break;
            }
            case 33: {
                n += this.cont.asDoubles().length * 8;
                break;
            }
            case 38: {
                n += this.cont.asDoubles().length * 8;
                break;
            }
            case 36: {
                if (((n += this.cont.asBytes().length + 4) & 3) <= 0) break;
                n = n - (n & 3) + 4;
                break;
            }
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                RList rList2 = this.cont.asList();
                for (int i = 0; i < rList2.size(); ++i) {
                    REXP rEXP = rList2.at(i);
                    n += rEXP == null ? 4 : new REXPFactory(rEXP).getBinaryLength();
                    if (n2 != 21) continue;
                    int n4 = n;
                    String string = rList2.keyAt(i);
                    n += 4;
                    if (((n += string == null ? 1 : string.length() + 1) & 3) <= 0) continue;
                    n = n - (n & 3) + 4;
                }
                if ((n & 3) <= 0) break;
                n = n - (n & 3) + 4;
                break;
            }
            case 34: {
                String[] stringArray = this.cont.asStrings();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] != null) {
                        try {
                            byte[] byArray = stringArray[i].getBytes(RConnection.transferCharset);
                            if (byArray[0] == -1) {
                                ++n;
                            }
                            n += byArray.length;
                            byArray = null;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    } else {
                        ++n;
                    }
                    ++n;
                }
                if ((n & 3) <= 0) break;
                n = n - (n & 3) + 4;
                break;
            }
        }
        if (n > 0xFFFFF0) {
            n += 4;
        }
        return n + 4;
    }

    public int getBinaryRepresentation(byte[] byArray, int n) throws REXPMismatchException {
        int n2 = this.getBinaryLength();
        boolean bl = n2 > 0xFFFFF0;
        boolean bl2 = false;
        REXPList rEXPList = this.getAttr();
        RList rList = null;
        if (rEXPList != null) {
            rList = rEXPList.asList();
        }
        if (rList != null && rList.size() > 0) {
            bl2 = true;
        }
        int n3 = this.type;
        int n4 = n;
        if (this.type == 27) {
            n3 = 34;
        }
        if (this.type == 17 || this.type == 21 || this.type == 20) {
            n3 = this.cont.asList() != null && this.cont.asList().isNamed() ? 21 : 20;
        }
        RTalk.setHdr(n3 | (bl2 ? 128 : 0), n2 - (bl ? 8 : 4), byArray, n);
        n += bl ? 8 : 4;
        if (bl2) {
            n = this.attr.getBinaryRepresentation(byArray, n);
        }
        switch (n3) {
            case 0: 
            case 7: {
                break;
            }
            case 1: {
                RTalk.setInt(this.cont.asInteger(), byArray, n);
                break;
            }
            case 2: {
                RTalk.setLong(Double.doubleToRawLongBits(this.cont.asDouble()), byArray, n);
                break;
            }
            case 32: {
                int[] nArray = this.cont.asIntegers();
                int n5 = 0;
                int n6 = n;
                while (n5 < nArray.length) {
                    RTalk.setInt(nArray[n5++], byArray, n6);
                    n6 += 4;
                }
                break;
            }
            case 36: {
                byte[] byArray2 = this.cont.asBytes();
                int n7 = n;
                RTalk.setInt(byArray2.length, byArray, n7);
                n7 += 4;
                if (byArray2.length <= 0) break;
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray[n7++] = (byte)(byArray2[i] == -128 ? 2 : (byArray2[i] == 0 ? 0 : 1));
                }
                while ((n7 & 3) != 0) {
                    byArray[n7++] = 3;
                }
                break;
            }
            case 33: {
                double[] dArray = this.cont.asDoubles();
                int n8 = 0;
                int n9 = n;
                while (n8 < dArray.length) {
                    RTalk.setLong(Double.doubleToRawLongBits(dArray[n8++]), byArray, n9);
                    n9 += 8;
                }
                break;
            }
            case 37: {
                byte[] byArray3 = this.cont.asBytes();
                RTalk.setInt(byArray3.length, byArray, n);
                System.arraycopy(byArray3, 0, byArray, n += 4, byArray3.length);
                break;
            }
            case 34: {
                int n10;
                String[] stringArray = this.cont.asStrings();
                int n11 = n;
                for (n10 = 0; n10 < stringArray.length; ++n10) {
                    if (stringArray[n10] != null) {
                        try {
                            byte[] byArray4 = stringArray[n10].getBytes(RConnection.transferCharset);
                            if (byArray4[0] == -1) {
                                byArray[n11++] = -1;
                            }
                            System.arraycopy(byArray4, 0, byArray, n11, byArray4.length);
                            n11 += byArray4.length;
                            byArray4 = null;
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    } else {
                        byArray[n11++] = -1;
                    }
                    byArray[n11++] = 0;
                }
                n10 = n11 - n;
                while ((n10 & 3) != 0) {
                    byArray[n11++] = 1;
                    ++n10;
                }
                break;
            }
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                int n12 = n;
                RList rList2 = this.cont.asList();
                if (rList2 == null) break;
                for (int i = 0; i < rList2.size(); ++i) {
                    REXP rEXP = rList2.at(i);
                    if (rEXP == null) {
                        rEXP = new REXPNull();
                    }
                    n12 = new REXPFactory(rEXP).getBinaryRepresentation(byArray, n12);
                    if (n3 != 21 && n3 != 23) continue;
                    n12 = new REXPFactory(new REXPSymbol(rList2.keyAt(i))).getBinaryRepresentation(byArray, n12);
                }
                break;
            }
            case 3: 
            case 19: {
                REXPFactory.getStringBinaryRepresentation(byArray, n, this.cont.asString());
            }
        }
        return n4 + n2;
    }

    public static int getStringBinaryRepresentation(byte[] byArray, int n, String string) {
        if (string == null) {
            string = "";
        }
        int n2 = n;
        try {
            byte[] byArray2 = string.getBytes(RConnection.transferCharset);
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
            byArray2 = null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byArray[n2++] = 0;
        while ((n2 & 3) != 0) {
            byArray[n2++] = 0;
        }
        return n2;
    }

    public static String xtName(int n) {
        if (n == 0) {
            return "NULL";
        }
        if (n == 1) {
            return "INT";
        }
        if (n == 3) {
            return "STRING";
        }
        if (n == 2) {
            return "REAL";
        }
        if (n == 6) {
            return "BOOL";
        }
        if (n == 32) {
            return "INT*";
        }
        if (n == 34) {
            return "STRING*";
        }
        if (n == 33) {
            return "REAL*";
        }
        if (n == 36) {
            return "BOOL*";
        }
        if (n == 38) {
            return "COMPLEX*";
        }
        if (n == 5) {
            return "SYMBOL";
        }
        if (n == 19) {
            return "SYMNAME";
        }
        if (n == 4) {
            return "LANG";
        }
        if (n == 17) {
            return "LIST";
        }
        if (n == 21) {
            return "LIST+T";
        }
        if (n == 20) {
            return "LIST/T";
        }
        if (n == 23) {
            return "LANG+T";
        }
        if (n == 22) {
            return "LANG/T";
        }
        if (n == 18) {
            return "CLOS";
        }
        if (n == 37) {
            return "RAW";
        }
        if (n == 7) {
            return "S4";
        }
        if (n == 16) {
            return "VECTOR";
        }
        if (n == 27) {
            return "STRING[]";
        }
        if (n == 26) {
            return "EXPR[]";
        }
        if (n == 127) {
            return "FACTOR";
        }
        if (n == 48) {
            return "UNKNOWN";
        }
        return "<unknown " + n + ">";
    }
}

