/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.Rserve;

import java.io.IOException;
import java.io.OutputStream;
import org.rosuda.REngine.Rserve.protocol.RPacket;
import org.rosuda.REngine.Rserve.protocol.RTalk;

public class RFileOutputStream
extends OutputStream {
    RTalk rt;
    boolean closed;

    RFileOutputStream(RTalk rTalk, String string) throws IOException {
        this.rt = rTalk;
        RPacket rPacket = this.rt.request(17, string);
        if (rPacket == null || !rPacket.isOk()) {
            throw new IOException(rPacket == null ? "Connection to Rserve failed" : "Request return code: " + rPacket.getStat());
        }
        this.closed = false;
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[1];
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("File is not open");
        }
        if (n2 < 0) {
            n2 = 0;
        }
        boolean bl = n2 > 0xFFFFF0;
        byte[] byArray2 = RTalk.newHdr(5, n2);
        RPacket rPacket = this.rt.request(20, byArray2, byArray, n, n2);
        if (rPacket == null || !rPacket.isOk()) {
            throw new IOException(rPacket == null ? "Connection to Rserve failed" : "Request return code: " + rPacket.getStat());
        }
    }

    public void close() throws IOException {
        RPacket rPacket = this.rt.request(18, (byte[])null);
        if (rPacket == null || !rPacket.isOk()) {
            throw new IOException(rPacket == null ? "Connection to Rserve failed" : "Request return code: " + rPacket.getStat());
        }
        this.closed = true;
    }

    public void flush() {
    }
}

