/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.metrics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.metrics.RpcActivityMBean;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsIntValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingInt;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingLong;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class RpcMetrics
implements Updater {
    private final MetricsRegistry registry = new MetricsRegistry();
    private final MetricsRecord metricsRecord;
    private final Server myServer;
    private static final Log LOG = LogFactory.getLog(RpcMetrics.class);
    RpcActivityMBean rpcMBean;
    public final MetricsTimeVaryingLong receivedBytes = new MetricsTimeVaryingLong("ReceivedBytes", this.registry);
    public final MetricsTimeVaryingLong sentBytes = new MetricsTimeVaryingLong("SentBytes", this.registry);
    public final MetricsTimeVaryingRate rpcQueueTime = new MetricsTimeVaryingRate("RpcQueueTime", this.registry);
    public final MetricsTimeVaryingRate rpcProcessingTime = new MetricsTimeVaryingRate("RpcProcessingTime", this.registry);
    public final MetricsIntValue numOpenConnections = new MetricsIntValue("NumOpenConnections", this.registry);
    public final MetricsIntValue callQueueLen = new MetricsIntValue("callQueueLen", this.registry);
    public final MetricsTimeVaryingInt authenticationFailures = new MetricsTimeVaryingInt("rpcAuthenticationFailures", this.registry);
    public final MetricsTimeVaryingInt authenticationSuccesses = new MetricsTimeVaryingInt("rpcAuthenticationSuccesses", this.registry);
    public final MetricsTimeVaryingInt authorizationFailures = new MetricsTimeVaryingInt("rpcAuthorizationFailures", this.registry);
    public final MetricsTimeVaryingInt authorizationSuccesses = new MetricsTimeVaryingInt("rpcAuthorizationSuccesses", this.registry);

    public RpcMetrics(String hostName, String port, Server server) {
        this.myServer = server;
        MetricsContext context = MetricsUtil.getContext("rpc");
        this.metricsRecord = MetricsUtil.createRecord(context, "metrics");
        this.metricsRecord.setTag("port", port);
        LOG.info((Object)("Initializing RPC Metrics with hostName=" + hostName + ", port=" + port));
        context.registerUpdater(this);
        this.rpcMBean = new RpcActivityMBean(this.registry, hostName, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdates(MetricsContext context) {
        RpcMetrics rpcMetrics = this;
        synchronized (rpcMetrics) {
            this.numOpenConnections.set(this.myServer.getNumOpenConnections());
            this.callQueueLen.set(this.myServer.getCallQueueLen());
            for (MetricsBase m : this.registry.getMetricsList()) {
                m.pushMetric(this.metricsRecord);
            }
        }
        this.metricsRecord.update();
    }

    public void shutdown() {
        if (this.rpcMBean != null) {
            this.rpcMBean.shutdown();
        }
    }
}

