/*
 * Decompiled with CFR 0.152.
 */
package com.nexr.rhive.hive.udf;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@Description(name="unfold", value="_FUNC_(x) - Returns the extended result of one column")
public class GenericUDTFUnFold
extends GenericUDTF {
    int numCols;
    DATA_TYPE[] data_types;
    Writable[] retCols;
    Writable[] cols;
    Object[] nullCols;
    ObjectInspector[] inputOIs;
    boolean pathParsed = false;
    boolean seenErrors = false;
    String delim = ",";

    public StructObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        this.inputOIs = args;
        this.numCols = args.length - 2;
        if (args.length < 3) {
            throw new UDFArgumentException("unfold() takes at least three arguments: the origin string, data type and deliminator");
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].getCategory() == ObjectInspector.Category.PRIMITIVE) continue;
            throw new UDFArgumentException("unfold()'s arguments have to be primitive type");
        }
        this.seenErrors = false;
        this.pathParsed = false;
        this.data_types = new DATA_TYPE[this.numCols];
        this.cols = new Writable[this.numCols];
        this.retCols = new Writable[this.numCols];
        this.nullCols = new Object[this.numCols];
        ArrayList<String> fieldNames = new ArrayList<String>(this.numCols);
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>(this.numCols);
        for (int i = 0; i < this.numCols; ++i) {
            fieldNames.add("c" + i);
            fieldOIs.add(this.getColumnInspector(args[i + 1].getTypeName()));
            this.cols[i] = this.getColumnWritable(args[i + 1].getTypeName());
            this.retCols[i] = this.cols[i];
            this.nullCols[i] = null;
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    private ObjectInspector getColumnInspector(String typeName) throws IllegalArgumentException {
        if (typeName.equals("int")) {
            return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        }
        if (typeName.equals("double")) {
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }
        if (typeName.equals("string")) {
            return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        }
        throw new IllegalArgumentException("can't support this type " + typeName);
    }

    private Writable getColumnWritable(String typeName) throws IllegalArgumentException {
        if (typeName.equals("int")) {
            return new IntWritable(0);
        }
        if (typeName.equals("double")) {
            return new DoubleWritable(0.0);
        }
        if (typeName.equals("string")) {
            return new Text();
        }
        throw new IllegalArgumentException("can't support this type : " + typeName);
    }

    public void process(Object[] args) throws HiveException {
        String originStr;
        if (args[0] == null) {
            this.forward(this.nullCols);
            return;
        }
        if (!this.pathParsed) {
            for (int i = 0; i < this.numCols; ++i) {
                this.data_types[i] = this.inputOIs[i + 1] instanceof StringObjectInspector ? DATA_TYPE.STRING : (this.inputOIs[i + 1] instanceof DoubleObjectInspector ? DATA_TYPE.DOUBLE : (this.inputOIs[i + 1] instanceof IntObjectInspector ? DATA_TYPE.INT : DATA_TYPE.NULLNAME));
            }
            String local_delim = ((StringObjectInspector)this.inputOIs[args.length - 1]).getPrimitiveJavaObject(args[args.length - 1]);
            if (local_delim != null && !local_delim.equals("")) {
                this.delim = local_delim;
            }
            this.pathParsed = true;
        }
        if ((originStr = ((StringObjectInspector)this.inputOIs[0]).getPrimitiveJavaObject(args[0])) == null) {
            this.forward(this.nullCols);
            return;
        }
        try {
            String[] originStrs = this.parseString(originStr, this.delim);
            block8: for (int i = 0; i < this.numCols; ++i) {
                if (originStrs[i] == null) {
                    this.retCols[i] = this.cols[i];
                }
                switch (this.data_types[i]) {
                    case STRING: {
                        ((Text)this.retCols[i]).set(originStrs[i]);
                        continue block8;
                    }
                    case DOUBLE: {
                        ((DoubleWritable)this.retCols[i]).set(Double.parseDouble(originStrs[i]));
                        continue block8;
                    }
                    case INT: {
                        ((IntWritable)this.retCols[i]).set((int)Double.parseDouble(originStrs[i]));
                        continue block8;
                    }
                    default: {
                        this.retCols[i] = this.cols[i];
                    }
                }
            }
            this.forward(this.retCols);
            return;
        }
        catch (Exception e) {
            if (!this.seenErrors) {
                this.seenErrors = true;
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(output));
            throw new HiveException(new String(output.toByteArray()));
        }
    }

    public String toString() {
        return "unfold";
    }

    public void close() throws HiveException {
    }

    private String[] parseString(String originStr, String delim) {
        StringTokenizer st = new StringTokenizer(originStr, delim);
        ArrayList<String> strs = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            strs.add(st.nextToken());
        }
        return strs.toArray(new String[0]);
    }

    static enum DATA_TYPE {
        STRING,
        DOUBLE,
        INT,
        NUMERIC,
        NULLNAME;

    }
}

