/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyDictionary$PyExposer;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyMapEntrySet;
import org.python.core.PyMapKeyValSet;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="dict")
public class PyDictionary
extends PyObject
implements ConcurrentMap {
    public static final PyType TYPE;
    protected final ConcurrentMap<PyObject, PyObject> table = Generic.concurrentMap();

    public PyDictionary() {
    }

    public PyDictionary(PyType subtype) {
        super(subtype);
    }

    public PyDictionary(Map<PyObject, PyObject> t) {
        this.table.putAll(t);
    }

    public PyDictionary(PyType subtype, Map<PyObject, PyObject> t) {
        super(subtype);
        this.table.putAll(t);
    }

    public PyDictionary(PyObject[] elements) {
        this();
        for (int i = 0; i < elements.length; i += 2) {
            this.table.put(elements[i], elements[i + 1]);
        }
    }

    @ExposedNew
    protected final void dict___init__(PyObject[] args, String[] keywords) {
        this.updateCommon(args, keywords, "dict");
    }

    public static PyObject fromkeys(PyObject keys) {
        return PyDictionary.fromkeys(keys, Py.None);
    }

    public static PyObject fromkeys(PyObject keys, PyObject value) {
        return PyDictionary.dict_fromkeys(TYPE, keys, value);
    }

    static final PyObject dict_fromkeys(PyType type, PyObject keys, PyObject value) {
        PyObject d = type.__call__();
        for (PyObject o : keys.asIterable()) {
            d.__setitem__(o, value);
        }
        return d;
    }

    @Override
    public int __len__() {
        return this.dict___len__();
    }

    final int dict___len__() {
        return this.table.size();
    }

    @Override
    public boolean __nonzero__() {
        return this.dict___nonzero__();
    }

    final boolean dict___nonzero__() {
        return this.table.size() != 0;
    }

    @Override
    public PyObject __finditem__(int index) {
        throw Py.TypeError("loop over non-sequence");
    }

    @Override
    public PyObject __finditem__(PyObject key) {
        return (PyObject)this.table.get(key);
    }

    protected final PyObject dict___getitem__(PyObject key) {
        PyObject missing;
        PyObject result = (PyObject)this.table.get(key);
        if (result != null) {
            return result;
        }
        PyType type = this.getType();
        if (type != TYPE && (missing = type.lookup("__missing__")) != null) {
            return missing.__get__(this, type).__call__(key);
        }
        throw Py.KeyError(key);
    }

    @Override
    public void __setitem__(PyObject key, PyObject value) {
        this.dict___setitem__(key, value);
    }

    final void dict___setitem__(PyObject key, PyObject value) {
        this.table.put(key, value);
    }

    @Override
    public void __delitem__(PyObject key) {
        this.dict___delitem__(key);
    }

    final void dict___delitem__(PyObject key) {
        Object ret = this.table.remove(key);
        if (ret == null) {
            throw Py.KeyError(key.toString());
        }
    }

    @Override
    public PyObject __iter__() {
        return this.dict___iter__();
    }

    final PyObject dict___iter__() {
        return this.iterkeys();
    }

    @Override
    public String toString() {
        return this.dict_toString();
    }

    final String dict_toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "{...}";
        }
        StringBuilder buf = new StringBuilder("{");
        for (Map.Entry entry : this.table.entrySet()) {
            buf.append(((PyObject)entry.getKey()).__repr__().toString());
            buf.append(": ");
            buf.append(((PyObject)entry.getValue()).__repr__().toString());
            buf.append(", ");
        }
        if (buf.length() > 1) {
            buf.delete(buf.length() - 2, buf.length());
        }
        buf.append("}");
        ts.exitRepr(this);
        return buf.toString();
    }

    @Override
    public PyObject __eq__(PyObject ob_other) {
        return this.dict___eq__(ob_other);
    }

    final PyObject dict___eq__(PyObject ob_other) {
        int bn;
        PyType thisType = this.getType();
        PyType otherType = ob_other.getType();
        if (otherType != thisType && !thisType.isSubType(otherType) && !otherType.isSubType(thisType)) {
            return null;
        }
        PyDictionary other = (PyDictionary)ob_other;
        int an = this.table.size();
        if (an != (bn = other.table.size())) {
            return Py.False;
        }
        PyList akeys = this.keys();
        for (int i = 0; i < an; ++i) {
            PyObject akey = akeys.pyget(i);
            PyObject bvalue = other.__finditem__(akey);
            if (bvalue == null) {
                return Py.False;
            }
            PyObject avalue = this.__finditem__(akey);
            if (avalue._eq(bvalue).__nonzero__()) continue;
            return Py.False;
        }
        return Py.True;
    }

    @Override
    public PyObject __ne__(PyObject ob_other) {
        return this.dict___ne__(ob_other);
    }

    final PyObject dict___ne__(PyObject ob_other) {
        PyObject eq_result = this.__eq__(ob_other);
        if (eq_result == null) {
            return null;
        }
        return eq_result.__not__();
    }

    final PyObject dict___lt__(PyObject ob_other) {
        int result = this.__cmp__(ob_other);
        if (result == -2) {
            return null;
        }
        return result < 0 ? Py.True : Py.False;
    }

    final PyObject dict___gt__(PyObject ob_other) {
        int result = this.__cmp__(ob_other);
        if (result == -2) {
            return null;
        }
        return result > 0 ? Py.True : Py.False;
    }

    final PyObject dict___le__(PyObject ob_other) {
        int result = this.__cmp__(ob_other);
        if (result == -2) {
            return null;
        }
        return result <= 0 ? Py.True : Py.False;
    }

    final PyObject dict___ge__(PyObject ob_other) {
        int result = this.__cmp__(ob_other);
        if (result == -2) {
            return null;
        }
        return result >= 0 ? Py.True : Py.False;
    }

    @Override
    public int __cmp__(PyObject ob_other) {
        return this.dict___cmp__(ob_other);
    }

    final int dict___cmp__(PyObject ob_other) {
        int bn;
        PyType thisType = this.getType();
        PyType otherType = ob_other.getType();
        if (otherType != thisType && !thisType.isSubType(otherType) && !otherType.isSubType(thisType)) {
            return -2;
        }
        PyDictionary other = (PyDictionary)ob_other;
        int an = this.table.size();
        if (an < (bn = other.table.size())) {
            return -1;
        }
        if (an > bn) {
            return 1;
        }
        PyList akeys = this.keys();
        PyList bkeys = other.keys();
        akeys.sort();
        bkeys.sort();
        for (int i = 0; i < bn; ++i) {
            PyObject bkey;
            PyObject akey = akeys.pyget(i);
            int c = akey._cmp(bkey = bkeys.pyget(i));
            if (c != 0) {
                return c;
            }
            PyObject avalue = this.__finditem__(akey);
            PyObject bvalue = other.__finditem__(bkey);
            if (avalue == null) {
                if (bvalue == null) continue;
                return -3;
            }
            if (bvalue == null) {
                return -3;
            }
            c = avalue._cmp(bvalue);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public boolean has_key(PyObject key) {
        return this.dict_has_key(key);
    }

    final boolean dict_has_key(PyObject key) {
        return this.table.containsKey(key);
    }

    @Override
    public boolean __contains__(PyObject o) {
        return this.dict___contains__(o);
    }

    final boolean dict___contains__(PyObject o) {
        return this.dict_has_key(o);
    }

    public PyObject get(PyObject key, PyObject default_object) {
        return this.dict_get(key, default_object);
    }

    final PyObject dict_get(PyObject key, PyObject default_object) {
        PyObject o = (PyObject)this.table.get(key);
        if (o == null) {
            return default_object;
        }
        return o;
    }

    public PyObject get(PyObject key) {
        return this.dict_get(key, Py.None);
    }

    public PyDictionary copy() {
        return this.dict_copy();
    }

    final PyDictionary dict_copy() {
        return new PyDictionary(this.table);
    }

    @Override
    public void clear() {
        this.dict_clear();
    }

    final void dict_clear() {
        this.table.clear();
    }

    public void update(PyObject other) {
        this.dict_update(new PyObject[]{other}, Py.NoKeywords);
    }

    final void dict_update(PyObject[] args, String[] keywords) {
        this.updateCommon(args, keywords, "update");
    }

    private void updateCommon(PyObject[] args, String[] keywords, String methName) {
        int nargs = args.length - keywords.length;
        if (nargs > 1) {
            throw PyBuiltinCallable.DefaultInfo.unexpectedCall(nargs, false, methName, 0, 1);
        }
        if (nargs == 1) {
            PyObject arg = args[0];
            Object proxy = arg.getJavaProxy();
            if (proxy instanceof Map) {
                this.merge((Map)proxy);
            } else if (arg.__findattr__("keys") != null) {
                this.merge(arg);
            } else {
                this.mergeFromSeq(arg);
            }
        }
        for (int i = 0; i < keywords.length; ++i) {
            this.dict___setitem__(Py.newString(keywords[i]), args[nargs + i]);
        }
    }

    private void merge(Map<Object, Object> other) {
        for (Map.Entry<Object, Object> entry : other.entrySet()) {
            this.dict___setitem__(Py.java2py(entry.getKey()), Py.java2py(entry.getValue()));
        }
    }

    private void merge(PyObject other) {
        if (other instanceof PyDictionary) {
            this.table.putAll(((PyDictionary)other).table);
        } else if (other instanceof PyStringMap) {
            this.mergeFromKeys(other, ((PyStringMap)other).keys());
        } else {
            this.mergeFromKeys(other, other.invoke("keys"));
        }
    }

    private void mergeFromKeys(PyObject other, PyObject keys) {
        for (PyObject key : keys.asIterable()) {
            this.dict___setitem__(key, other.__getitem__(key));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergeFromSeq(PyObject other) {
        PyObject i;
        PyObject pairs = other.__iter__();
        boolean bl = false;
        while ((i = pairs.__iternext__()) != null) {
            void pair;
            try {
                i = PySequence.fastSequence(i, "");
            }
            catch (PyException pye) {
                if (pye.match(Py.TypeError)) {
                    throw Py.TypeError(String.format("cannot convert dictionary update sequence element #%d to a sequence", (int)pair));
                }
                throw pye;
            }
            int n = i.__len__();
            if (n != 2) {
                throw Py.ValueError(String.format("dictionary update sequence element #%d has length %d; 2 is required", (int)pair, n));
            }
            this.dict___setitem__(i.__getitem__(0), i.__getitem__(1));
            ++pair;
        }
    }

    public PyObject setdefault(PyObject key) {
        return this.dict_setdefault(key, Py.None);
    }

    public PyObject setdefault(PyObject key, PyObject failobj) {
        return this.dict_setdefault(key, failobj);
    }

    final PyObject dict_setdefault(PyObject key, PyObject failobj) {
        PyObject oldValue = this.table.putIfAbsent(key, failobj);
        if (oldValue == null) {
            return failobj;
        }
        return oldValue;
    }

    final PyObject dict_setifabsent(PyObject key, PyObject failobj) {
        PyObject oldValue = this.table.putIfAbsent(key, failobj);
        if (oldValue == null) {
            return Py.None;
        }
        return oldValue;
    }

    public PyObject pop(PyObject key) {
        return this.dict_pop(key, null);
    }

    public PyObject pop(PyObject key, PyObject defaultValue) {
        return this.dict_pop(key, defaultValue);
    }

    final PyObject dict_pop(PyObject key, PyObject defaultValue) {
        if (!this.table.containsKey(key)) {
            if (defaultValue == null) {
                throw Py.KeyError("popitem(): dictionary is empty");
            }
            return defaultValue;
        }
        return (PyObject)this.table.remove(key);
    }

    public PyObject popitem() {
        return this.dict_popitem();
    }

    final PyObject dict_popitem() {
        Iterator it = this.table.entrySet().iterator();
        if (!it.hasNext()) {
            throw Py.KeyError("popitem(): dictionary is empty");
        }
        Map.Entry entry = it.next();
        PyTuple tuple = new PyTuple((PyObject)entry.getKey(), (PyObject)entry.getValue());
        it.remove();
        return tuple;
    }

    public PyList items() {
        return this.dict_items();
    }

    final PyList dict_items() {
        ArrayList<PyTuple> list = new ArrayList<PyTuple>(this.table.size());
        for (Map.Entry entry : this.table.entrySet()) {
            list.add(new PyTuple((PyObject)entry.getKey(), (PyObject)entry.getValue()));
        }
        return new PyList(list);
    }

    public PyList keys() {
        return this.dict_keys();
    }

    final PyList dict_keys() {
        return new PyList(new ArrayList(this.table.keySet()));
    }

    final PyList dict_values() {
        return new PyList(new ArrayList(this.table.values()));
    }

    public PyObject iteritems() {
        return this.dict_iteritems();
    }

    final PyObject dict_iteritems() {
        return new ItemsIter(this.table.entrySet());
    }

    public PyObject iterkeys() {
        return this.dict_iterkeys();
    }

    final PyObject dict_iterkeys() {
        return new ValuesIter(this.table.keySet());
    }

    public PyObject itervalues() {
        return this.dict_itervalues();
    }

    final PyObject dict_itervalues() {
        return new ValuesIter(this.table.values());
    }

    @Override
    public int hashCode() {
        return this.dict___hash__();
    }

    final int dict___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    @Override
    public boolean isSequenceType() {
        return false;
    }

    @Override
    public Set entrySet() {
        return new PyMapEntrySet(this.table.entrySet());
    }

    @Override
    public Set keySet() {
        return new PyMapKeyValSet(this.table.keySet());
    }

    @Override
    public Collection values() {
        return new PyMapKeyValSet(this.table.values());
    }

    @Override
    public void putAll(Map map) {
        Iterator i$ = map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = i$.next();
            this.table.put(Py.java2py(entry.getKey()), Py.java2py(entry.getValue()));
        }
    }

    @Override
    public Object remove(Object key) {
        return PyDictionary.tojava(this.table.remove(Py.java2py(key)));
    }

    @Override
    public Object put(Object key, Object value) {
        return PyDictionary.tojava(this.table.put(Py.java2py(key), Py.java2py(value)));
    }

    @Override
    public Object get(Object key) {
        return PyDictionary.tojava(this.table.get(Py.java2py(key)));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.table.containsValue(Py.java2py(value));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.table.containsKey(Py.java2py(key));
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    @Override
    public int size() {
        return this.table.size();
    }

    static final Object tojava(Object val) {
        return val == null ? null : ((PyObject)val).__tojava__(Object.class);
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        return PyDictionary.tojava(this.table.putIfAbsent(Py.java2py(key), Py.java2py(value)));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.table.remove(Py.java2py(key), Py.java2py(value));
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        return this.table.replace(Py.java2py(key), Py.java2py(oldValue), Py.java2py(newValue));
    }

    @Override
    public Object replace(Object key, Object value) {
        return PyDictionary.tojava(this.table.replace(Py.java2py(key), Py.java2py(value)));
    }

    static {
        PyType.addBuilder(PyDictionary.class, new PyDictionary$PyExposer());
        TYPE = PyType.fromClass(PyDictionary.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ItemsIter
    extends PyIterator {
        private final Iterator<Map.Entry<PyObject, PyObject>> iterator;
        private final int size;

        public ItemsIter(Set<Map.Entry<PyObject, PyObject>> items) {
            this.iterator = items.iterator();
            this.size = items.size();
        }

        @Override
        public PyObject __iternext__() {
            if (PyDictionary.this.table.size() != this.size) {
                throw Py.RuntimeError("dictionary changed size during iteration");
            }
            if (!this.iterator.hasNext()) {
                return null;
            }
            Map.Entry<PyObject, PyObject> entry = this.iterator.next();
            return new PyTuple(entry.getKey(), entry.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValuesIter
    extends PyIterator {
        private final Iterator<PyObject> iterator;
        private final int size;

        public ValuesIter(Collection<PyObject> values) {
            this.iterator = values.iterator();
            this.size = values.size();
        }

        @Override
        public PyObject __iternext__() {
            if (PyDictionary.this.table.size() != this.size) {
                throw Py.RuntimeError("dictionary changed size during iteration");
            }
            if (!this.iterator.hasNext()) {
                return null;
            }
            return this.iterator.next();
        }
    }
}

