/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.BaseHashIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.NonUniqueHashCursor;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.util.IntArray;
import org.h2.util.ValueHashMap;
import org.h2.value.Value;

public class NonUniqueHashIndex
extends BaseHashIndex {
    private ValueHashMap<IntArray> rows;
    private TableData tableData;
    private long rowCount;

    public NonUniqueHashIndex(TableData tableData, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        super(tableData, n, string, indexColumnArray, indexType);
        this.tableData = tableData;
        this.reset();
    }

    private void reset() {
        this.rows = ValueHashMap.newInstance(this.table.getDatabase());
        this.rowCount = 0L;
    }

    public void truncate(Session session) {
        this.reset();
    }

    public void add(Session session, Row row) throws SQLException {
        Value value = this.getKey(row);
        IntArray intArray = this.rows.get(value);
        if (intArray == null) {
            intArray = new IntArray(1);
            this.rows.put(value, intArray);
        }
        intArray.add((int)row.getKey());
        ++this.rowCount;
    }

    public void remove(Session session, Row row) throws SQLException {
        if (this.rowCount == 1L) {
            this.reset();
        } else {
            Value value = this.getKey(row);
            IntArray intArray = this.rows.get(value);
            if (intArray.size() == 1) {
                this.rows.remove(value);
            } else {
                intArray.removeValue((int)row.getKey());
            }
            --this.rowCount;
        }
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        if (searchRow == null || searchRow2 == null) {
            throw Message.throwInternalError();
        }
        if (searchRow != searchRow2 && this.compareKeys(searchRow, searchRow2) != 0) {
            throw Message.throwInternalError();
        }
        IntArray intArray = this.rows.get(this.getKey(searchRow));
        return new NonUniqueHashCursor(session, this.tableData, intArray);
    }

    public long getRowCount(Session session) {
        return this.rowCount;
    }

    public long getRowCountApproximation() {
        return this.rowCount;
    }
}

