% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateGremlins.R
\name{estimateGremlinsModel}
\alias{estimateGremlinsModel}
\title{Estimate Gremlin's Model - Hierarchical MNL}
\usage{
estimateGremlinsModel(
  data,
  design,
  Priors = NULL,
  R = NULL,
  keepEvery = 1,
  verbose = TRUE,
  num_lambda_segments = 2,
  constraints = NULL,
  startingValues = NULL,
  previous_iterations = 0,
  Atchade_slope_tuning = 0.1,
  Atchade_lambda_tuning = 10
)
}
\arguments{
\item{data}{A matrix containing the raw data.
The first column the respondent identifier, followed by the design number, the remaining
columns indicate the choices for the tasks that coincide to the design file.}

\item{design}{A matrix representing the coded (dummy of effects) design file.  The design file should be
formatted as a matrix with number of versions X number of tasks X number of alternatives
rows and number of parameters + 3 columns.  The first column contains the version number,
the second columns contains the task number, the third column contains the alternative,
and the remaining columns contain the coded design.  A generic Sawtooth Software design
file can be converted to this format using the \code{\link{code_sawtooth_design}} function.}

\item{Priors}{A data structure that contains the priors for to the model.  Can be null indicating
the use of default priors or must contain a full prior specification.}

\item{R}{The number of repetitions in the chain}

\item{keepEvery}{saves every keepEvery-th draw for output}

\item{verbose}{Print intermediate results to the screen (default = TRUE)}

\item{num_lambda_segments}{(Default = 2) The number of segments for the scale factor}

\item{constraints}{(Optional) a vector of length n-param specifying the constraints
to impose on the parameters or NULL.  a 1 indicates the parameter is constrained to be positive
a -1 constrains to be  negative, and a 0 indicates no constraint.}

\item{startingValues}{(Optional) starting values to use for the MCMC algorithm.  This is a list of
containing: slope = a nRespondent by nParamter matrix of slopes for the respondent
            slopeBar = a nParameter vector of the slopeBar parameter
            slopeCov = a nParameter by nParameter matrix containing the variance covariance matrix
                       for the slopeBar parameter
            lambda = a nSegment vector containing the starting values for the lambda parameters.  The first
                     element in the vector should be 1.
            segMembership = a nRespondent vector containing the segment membership for each respondent.
            phi_lambda = a nParameter vector containing the base probabilities that an individual belongs
                         to each segment.  Should sum to 1.}

\item{previous_iterations}{The number of previous iterations run.  This parameter is used for the Atchade
adaptive MCMC step size algorithm.  This is used since the Atchade update does not happen for less
than 1000 iterations.  (Default = 0)}

\item{Atchade_slope_tuning}{The tuning factor to use for Atchade step for the slopes parameter.  Larger values
decrease the acceptance rate.  (Default = 0.01)}

\item{Atchade_lambda_tuning}{The tuning factor to use for the Atchade step for the lambda parameter.  Larger
values decrease the acceptance rate. (Default = 10)}
}
\value{
A data structure containing the draws from the complete MCMC chain
}
\description{
The function estimates the model described in "Gremlin's in the Data: Identifying the
Information Content of Research Subjects" (Howell et al.
(2021) <doi:10.1177/0022243720965930>) using a hierarchical multinomial logit model
}
\examples{

truck_design_file <- system.file("extdata", "simTruckDesign.csv", package = "RGremlinsConjoint")
truck_data_file <- system.file("extdata", "simTruckData.csv", package = "RGremlinsConjoint")

truckDesign <- read.csv(truck_design_file)
truckData <- read.csv(truck_data_file)
outputSimData_burn <- estimateGremlinsModel(truckData,
                                            truckDesign,
                                            R = 10,
                                            keepEvery = 1,
                                            num_lambda_segments = 2)

}
\seealso{
\code{\link{code_sawtooth_design}}
}
