% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genPlotGIS.R
\name{genPlotGIS}
\alias{genPlotGIS}
\title{Plot satellite images with a GIS format}
\usage{
genPlotGIS(r, region = NULL, ...)
}
\arguments{
\item{r}{a \code{Raster*} class object with the image or image stack to be plotted.}

\item{region}{a \code{Polygon} class object defining the area of interest.}

\item{...}{argument for nested functions:
\itemize{
  \item \code{compOpt} list to fit the size and the location of the GIS 
  components as the arrow and the scales.
  \item \code{proj} a \code{CRS} class object defining the coordinate 
  reference system of the plot.
  \item \code{...} any argument accepted by the \code{spplot} function.
}}
}
\value{
this function does not return anything.
}
\description{
This function displays satellite images with the usual format in geographic
information systems (GIS), i.e., adding a scale, north arrow, and the border
of the region of interest (optional).
}
\details{
This is a wrapper function of \code{spplot} and hence displays any 
\code{Raster*} object and accepts all of its parameters. The function adds a
scale, a north arrow and a polygon in the area of interest. If necessary, the
function automatically reprojects the polygon to match the projection of the
\code{raster}. The projection of the map can be changed by modifying the 
\code{proj} argument. The position in the graph of the arrow and scale bar
is measured in relative distances (0-1) to the lower left corner of the
graph. Their positions can be modified with the argument \code{compOpt}.
}
\examples{
# load the ndvi object of Navarre
data(ex.ndvi.navarre)
# load a spatial polygon object of Navarre
data(ex.navarre)

# show a panel of 4 maps, one per date
# the region of interest is shown in the last map
genPlotGIS(r = ex.ndvi.navarre[[1:4]],
           region = ex.navarre,
           which = c(4), # show region only in the 4th image
           wComp = c(4) # show component only in the 4th image
)

\dontrun{
# plot the land surface temperature of the first date available in 2011 in Navarre
# using color palette
library('RColorBrewer')
my.palette <- rev(brewer.pal(n = 9, name = "YlOrRd"))
genPlotGIS(r = ex.ndvi.navarre[[1]],
           region = ex.navarre,
           proj = CRS("+init=epsg:4670"), # project all components
           col.regions = colorRampPalette(my.palette)
)
}

# change scale text relative Y
genPlotGIS(r = ex.ndvi.navarre[[1:4]],
           region = ex.navarre,
           proj = CRS("+init=epsg:4670"),
           compOpt=list(
           # arrow relatives 0-1
           ArrowRelativeX = 0.85,
           ArrowRelativeY = 0.1,
           ArrowRelativeSize = 0.15,
           # scale relatives 0-1
           scaleRelativeX = 0.1,
           scaleRelativeY = 0.1,
           scaleRelativeSize = 0.15,
           # scale text relatives 0-1
           scaleLabelRelativeX = 0.1,
           scaleLabelRelativeY = 0.2,
           scaleLabelSize = 5000
        )
)
}
