% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{predict.fit}
\alias{predict.fit}
\title{Predictions}
\usage{
\method{predict}{fit}(object, n.ahead = 10, exogenous = "mean", returnFit = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{NAWRUfit}, \code{TFPfit}, or \code{KuttnerFit} 
(objects of class \code{fit}).}

\item{n.ahead}{An integer specifying the prediction horizon.}

\item{exogenous}{A character string specifying the computation of exogenous variables 
included in the model (if applicable). Valid options are \code{exogenous = "mean"} and 
\code{exogenous = "last".}}

\item{returnFit}{A logical. If \code{TRUE}, an object of the same class as \code{fit}
where the list entry \code{tsl} is replaced. If \code{FALSE}, only the new time series 
list is returned.}

\item{...}{Ignored.}
}
\value{
The fitted object with an updated time series list \code{tsl}. If 
  \code{returnFit = FALSE}, only the updated time series list is returned.
}
\description{
Computes predictions for an object of class \code{NAWRUfit, TFPfit}, or 
\code{KuttnerFit} estimated via MLE or Bayesian methods (objects of class \code{fit}).
}
