% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{.postNIG}
\alias{.postNIG}
\title{Draws from the posterior of parameters of a normal model with normal inverse gamma prior.}
\usage{
.postNIG(Y, X, betaLast, betaDistr, sigmaDistr)
}
\arguments{
\item{Y}{A \code{Tn x 1} vector with the dependent variable.}

\item{X}{A \code{Tn x k} matrix with the \code{k} explanatory variables.}

\item{betaLast}{A \code{k x 1} vector containing the last draw.}

\item{betaDistr}{A \code{4 x k} matrix with prior distribution and box constraints for
the parameters of each variable. In each column, the first two entries contain the
prior hyperparameters and the last two entries the upper and lower bound.}

\item{sigmaDistr}{A \code{1 x k} matrix with prior distribution and box constraints for
the innovation variance. The first two entries contain the prior hyperparameters and
the last two entries the upper and lower bound.}
}
\value{
A list with a draws for beta and the innovation variance.
}
\description{
Draws from the posterior of parameters of a normal model with normal inverse gamma prior.
}
\details{
Draws from the posterior are obtained by conjugacy of the Normal-Inverse-Gamma
distribution.
}
\keyword{internal}
