% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segments.R
\name{list_segments}
\alias{list_segments}
\title{Segments}
\usage{
list_segments(start.index = NULL, max.results = NULL, token)
}
\arguments{
\item{start.index}{integer. An index of the first segment to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of segments to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
The Segments collection is a set of Segment resources, each of which describes one of the user's default advanced segments or custom segments.
\item{id}{Segment ID.}
\item{kind}{Resource type for Analytics segment.}
\item{segmentId}{Segment ID. Can be used with the 'segment' parameter in Core Reporting API.}
\item{name}{Segment name.}
\item{definition}{Segment definition.}
\item{type}{Type for a segment. Possible values are "BUILT_IN" or "CUSTOM".}
\item{created}{Time the segment was created.}
\item{updated}{Time the segment was last modified.}
}
\description{
Lists segments to which the user has access.
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/segments}{Management API - Segments Overview}
}
\seealso{
Other Management API: \code{\link{get_custom_dimension}},
  \code{\link{get_custom_metric}},
  \code{\link{get_experiment}}, \code{\link{get_filter}},
  \code{\link{get_goal}}, \code{\link{get_profile}},
  \code{\link{get_unsampled_report}},
  \code{\link{get_upload}}, \code{\link{get_webproperty}},
  \code{\link{list_accounts}},
  \code{\link{list_custom_data_sources}},
  \code{\link{list_custom_dimensions}},
  \code{\link{list_custom_metrics}},
  \code{\link{list_experiments}},
  \code{\link{list_filters}}, \code{\link{list_goals}},
  \code{\link{list_profiles}},
  \code{\link{list_unsampled_reports}},
  \code{\link{list_uploads}},
  \code{\link{list_webproperties}}
}

