% Generated by roxygen2 (4.0.1): do not edit by hand
\name{set_query}
\alias{set_query}
\title{Set Google Analytics report query}
\usage{
set_query(profile.id = NULL, start.date = NULL, end.date = NULL,
  metrics = NULL, dimensions = NULL, sort = NULL, filters = NULL,
  segment = NULL, start.index = NULL, max.results = NULL)
}
\arguments{
\item{profile.id}{character or integer. Unique table ID for retrieving Analytics data. Table ID is of the form ga:XXXX, where XXXX is the Analytics view (profile) ID.}

\item{start.date}{character. Start date for fetching Analytics data. Requests can specify a start date formatted as YYYY-MM-DD, or as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is 7daysAgo.}

\item{end.date}{character. End date for fetching Analytics data. Request can should specify an end date formatted as YYYY-MM-DD, or as a relative date (e.g., today, yesterday, or 7daysAgo). The default value is yesterday.}

\item{metrics}{character. A comma-separated list of Analytics metrics.}

\item{dimensions}{character. A comma-separated list of Analytics dimensions.}

\item{sort}{character. A comma-separated list of dimensions or metrics that determine the sort order for Analytics data.}

\item{filters}{character. A comma-separated list of dimension or metric filters to be applied to Analytics data.}

\item{segment}{character. An Analytics segment to be applied to data.}

\item{start.index}{integer. An index of the first entity to retrieve. Use this parameter as a pagination mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of entries to include in this feed.}
}
\value{
\code{GAQuery} class object.
}
\description{
\code{set_query} create a query object the for Google Analytics report data.
}
\examples{
set_query(profile.id = "ga:00000000", start.date = "7daysAgo", end.date = "yesterday",
          metrics = "ga:users,ga:sessions,ga:pageviews", dimensions = "ga:date")
query <- set_query(profile.id = "ga:00000000", start.date = "31daysAgo", end.date = "yesterday",
                   metrics = "ga:sessions,ga:pageviews", dimensions = "ga:source,ga:medium")
query
query$sort <- "-ga:sessions"
query
query$sort <- NULL
query
}
\keyword{internal}

