% Generated by roxygen2 (4.0.1): do not edit by hand
\name{get_accounts}
\alias{get_accounts}
\title{Lists all accounts which the user has access to}
\usage{
get_accounts(start.index = NULL, max.results = NULL, token,
  verbose = getOption("rga.verbose", FALSE))
}
\arguments{
\item{start.index}{integer. An index of the first account to retrieve. Use this parameter as a pagi- nation mechanism along with the max-results parameter.}

\item{max.results}{integer. The maximum number of accounts to include in this response.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}

\item{verbose}{logical. Should print information verbose?}
}
\value{
A data frame with Google Analytics management data.
\item{id}{account ID.}
\item{name}{account name.}
\item{created}{time the account was created.}
\item{updated}{time the account was last modified.}
}
\description{
Lists all accounts which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/accounts}{Google Management API - Accounts}
}
\seealso{
\code{\link{authorize}}

Other The.Google.Analytics.Management.API: \code{\link{get_goals}};
  \code{\link{get_profiles}}; \code{\link{get_segments}};
  \code{\link{get_webproperties}}
}

