/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.event.ScheduleEvent;
import freak.core.event.ScheduleEventListener;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Module;
import freak.core.observer.Observer;
import freak.core.stoppingcriterion.StoppingCriterion;
import freak.core.view.AbstractView;
import freak.core.view.View;
import freak.core.view.swingsupport.FreakSwingModel;
import freak.core.view.swingsupport.UpdateManager;
import freak.gui.scheduleeditor.ObserverTreeCellRenderer;
import freak.gui.scheduleeditor.ObserverTreeElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class ScheduleView
extends AbstractView
implements ScheduleEventListener,
FreakSwingModel,
BatchEventListener {
    private transient SchedulePanel schedulePanel;
    private transient JTextField optimumField;
    private transient JPanel wrapper;

    public ScheduleView(Schedule schedule) {
        super(schedule);
    }

    public Class[] getInputDataTypes() {
        return new Class[]{Schedule.class};
    }

    public JPanel createPanel() {
        this.schedulePanel = new SchedulePanel(this.getSchedule());
        this.wrapper = new JPanel();
        JPanel scroller = new JPanel();
        scroller.setLayout(new BorderLayout());
        FlowLayout f = new FlowLayout();
        f.setAlignment(3);
        this.wrapper.setLayout(f);
        this.wrapper.setBackground(Color.white);
        this.wrapper.add(this.schedulePanel);
        scroller.add(new JScrollPane(this.wrapper));
        return scroller;
    }

    public String getName() {
        return "Schedule Information Table";
    }

    public String getDescription() {
        return "Displays information about the schedule in a table.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleEdited(ScheduleEvent evt) {
        ScheduleView scheduleView = this;
        synchronized (scheduleView) {
            if (this.schedulePanel != null) {
                this.schedulePanel = new SchedulePanel(this.getSchedule());
                this.wrapper.removeAll();
                this.wrapper.add(this.schedulePanel);
            }
        }
        UpdateManager.markDirty(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchStarted(BatchEvent evt) {
        ScheduleView scheduleView = this;
        synchronized (scheduleView) {
            if (this.schedulePanel != null) {
                this.schedulePanel = new SchedulePanel(this.getSchedule());
                this.wrapper.removeAll();
                this.wrapper.add(this.schedulePanel);
            }
        }
        UpdateManager.markDirty(this);
    }

    public void createEvents() {
        super.createEvents();
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
    }

    public void flush() {
        if (this.schedulePanel != null) {
            this.schedulePanel.repaint();
        }
    }

    class SchedulePanel
    extends JPanel {
        private Schedule schedule;
        private int row = 0;
        private DefaultMutableTreeNode rootNode;
        private DefaultTreeModel treeModel;
        private JTree treeObsItems;

        public SchedulePanel(Schedule schedule) {
            this.schedule = schedule;
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createCompoundBorder(new EtchedBorder(), new EmptyBorder(0, 2, 0, 2)));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            if (schedule.getMapper() == null) {
                this.addModule("Search Space", schedule.getGenotypeSearchSpace());
            } else {
                this.addModule("Phenotype Search Space", schedule.getPhenotypeSearchSpace());
                this.addModule("Genotype Search Space", schedule.getGenotypeSearchSpace());
            }
            this.addModule("Fitness Function", schedule.getRealFitnessFunction());
            this.addModule("Operator Graph", schedule.getOperatorGraph());
            StoppingCriterion[] stoppingCriteria = schedule.getStoppingCriteria();
            int i = 0;
            while (i < stoppingCriteria.length) {
                this.addModule("Stopping Criterion", stoppingCriteria[i]);
                ++i;
            }
            this.addModule("Population Model", schedule.getPopulationManager());
            this.addModule("Initialization Operator", schedule.getInitialization());
            if (schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction) {
                Double val2;
                SingleObjectiveFitnessFunction fitness = (SingleObjectiveFitnessFunction)schedule.getFitnessFunction();
                try {
                    Double opt = new Double(fitness.getOptimalFitnessValue());
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = this.row;
                    gridBagConstraints.anchor = 17;
                    gridBagConstraints.insets = new Insets(this.row != 0 ? 10 : 0, 0, 0, 5);
                    gridBagConstraints.weightx = 0.1;
                    gridBagConstraints.weighty = 0.1;
                    gridBagConstraints.fill = 1;
                    this.add((Component)new JLabel("Optimum"), gridBagConstraints);
                    gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.gridy = this.row;
                    gridBagConstraints.anchor = 17;
                    gridBagConstraints.insets = new Insets(this.row != 0 ? 10 : 0, 0, 0, 0);
                    gridBagConstraints.weightx = 0.1;
                    gridBagConstraints.weighty = 0.1;
                    gridBagConstraints.fill = 1;
                    ScheduleView.this.optimumField = new JTextField(opt.toString());
                    ScheduleView.this.optimumField.setEditable(false);
                    ScheduleView.this.optimumField.setBorder(new EmptyBorder(2, 2, 2, 2));
                    ScheduleView.this.optimumField.setBackground(Color.white);
                    this.add((Component)ScheduleView.this.optimumField, gridBagConstraints);
                    ++this.row;
                }
                catch (UnsupportedOperationException opt) {
                    // empty catch block
                }
                try {
                    val2 = new Double(fitness.getLowerBound());
                    this.addMiscInfo("Lower Bound", val2);
                }
                catch (UnsupportedOperationException val2) {
                    // empty catch block
                }
                try {
                    val2 = new Double(fitness.getUpperBound());
                    this.addMiscInfo("Upper Bound", val2);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.row++;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            this.initTree();
            this.treeObsItems.setBorder(new TitledBorder("Observers and Views"));
            this.add((Component)this.treeObsItems, gridBagConstraints);
        }

        private void addMiscInfo(String label, Object value) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.row;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(this.row != 0 ? 10 : 0, 0, 0, 5);
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.fill = 1;
            this.add((Component)new JLabel(label), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = this.row;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(this.row != 0 ? 10 : 0, 0, 0, 0);
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.fill = 1;
            JTextField valueField = new JTextField(value.toString());
            valueField.setEditable(false);
            valueField.setBorder(new EmptyBorder(2, 2, 2, 2));
            valueField.setBackground(Color.white);
            this.add((Component)valueField, gridBagConstraints);
            ++this.row;
        }

        private void addModule(String type, Module module) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.row;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(this.row != 0 ? 10 : 0, 0, 0, 5);
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.fill = 1;
            this.add((Component)new JLabel(type), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = this.row;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(this.row != 0 ? 10 : 0, 0, 0, 0);
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.1;
            gridBagConstraints.fill = 1;
            JTextField moduleNameTextField = new JTextField(module.getName());
            moduleNameTextField.setEditable(false);
            moduleNameTextField.setBorder(new EmptyBorder(2, 2, 2, 2));
            moduleNameTextField.setBackground(Color.white);
            this.add((Component)moduleNameTextField, gridBagConstraints);
            ++this.row;
            if (module instanceof Configurable) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = this.row++;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 0.1;
                gridBagConstraints.weighty = 0.1;
                gridBagConstraints.fill = 1;
                JTextField configurationTextField = new JTextField(((Configurable)module).getConfiguration().getDescription());
                configurationTextField.setEditable(false);
                configurationTextField.setBorder(new EmptyBorder(2, 2, 2, 2));
                configurationTextField.setBackground(Color.white);
                this.add((Component)configurationTextField, gridBagConstraints);
            }
        }

        private void initTree() {
            this.treeObsItems = new JTree();
            this.treeObsItems.setEditable(false);
            this.rootNode = new DefaultMutableTreeNode();
            this.treeModel = new DefaultTreeModel(this.rootNode);
            this.treeObsItems.setModel(this.treeModel);
            ObserverTreeCellRenderer renderer = new ObserverTreeCellRenderer();
            this.treeObsItems.setModel(this.treeModel);
            this.treeObsItems.setCellRenderer(renderer);
            this.treeObsItems.setRootVisible(false);
            this.treeObsItems.setShowsRootHandles(true);
            this.treeObsItems.getSelectionModel().setSelectionMode(1);
            this.treeObsItems.setExpandsSelectedPaths(true);
            ToolTipManager.sharedInstance().registerComponent(this.treeObsItems);
            for (Observer o : ScheduleView.this.getSchedule().getObserverManager().getActiveObservers()) {
                DefaultMutableTreeNode obsNode = new DefaultMutableTreeNode(new ObserverTreeElement(o));
                obsNode.add(new DefaultMutableTreeNode(ObserverTreeElement.getNoViewTreeElement()));
                this.treeModel.insertNodeInto(obsNode, this.rootNode, this.rootNode.getChildCount());
                TreePath path = new TreePath(obsNode.getPath());
                this.treeObsItems.setSelectionPath(path);
                Iterator views = o.getViews().iterator();
                while (views.hasNext()) {
                    this.addView((View)views.next(), obsNode);
                }
            }
            this.treeObsItems.setSelectionPath(null);
        }

        private void addView(View v, DefaultMutableTreeNode obsNode) {
            DefaultMutableTreeNode viewNode = new DefaultMutableTreeNode(new ObserverTreeElement(v));
            if (obsNode.getChildAt(0).toString().equals(ObserverTreeElement.getNoViewTreeElement().toString())) {
                this.treeModel.removeNodeFromParent((MutableTreeNode)obsNode.getChildAt(0));
            }
            this.treeModel.insertNodeInto(viewNode, obsNode, obsNode.getChildCount());
            TreePath path = new TreePath(viewNode.getPath());
            this.treeObsItems.setSelectionPath(path);
        }
    }
}

