/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace.logictree;

import freak.module.searchspace.logictree.AtomicNode;
import freak.module.searchspace.logictree.Data;
import java.io.Serializable;

public class VariableConstantNode
implements AtomicNode,
Serializable {
    private int value;
    private final int standard = 3;
    private int maxValue = 0;

    public VariableConstantNode(int maxValue) {
        this.maxValue = maxValue > 0 ? maxValue : 3;
        this.value = Data.nextRandInt(this.maxValue) + 1;
    }

    public VariableConstantNode(int maxValue, int value) {
        this.maxValue = maxValue > 0 ? maxValue : 3;
        this.value = value > 0 && value <= this.maxValue ? value : Data.nextRandInt(this.maxValue) + 1;
    }

    public int getValue() {
        return this.value;
    }

    public int getValue(byte[] row) {
        return this.getValue();
    }

    void setValue(int val) {
        if (val > 0 && val <= this.maxValue) {
            this.value = val;
        }
    }

    void setMaxValue(int maxValue) {
        if (maxValue > 0) {
            this.maxValue = maxValue;
        }
    }

    void setRandomValue() {
        this.value = Data.nextRandInt(this.maxValue) + 1;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof VariableConstantNode)) {
            return false;
        }
        return ((VariableConstantNode)o).getValue() == this.getValue();
    }

    public String toString() {
        String rueckgabe = "" + this.value;
        return rueckgabe;
    }

    public Object clone() {
        VariableConstantNode cn = new VariableConstantNode(this.maxValue, this.value);
        return cn;
    }
}

