/*
 * Decompiled with CFR 0.152.
 */
package freak.core.modulesupport;

import freak.Freak;
import freak.core.graph.Operator;
import freak.core.searchspace.SearchSpace;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.security.CodeSource;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public class ClassCollector {
    private static String startedFrom = null;
    private static Collection jarFreakClassFilesBuffer;

    public static String[] getClassPaths() {
        return System.getProperty("java.class.path").split(System.getProperty("path.separator"));
    }

    private static Collection getJarFreakModuleClassnames(String jarfile) {
        if (jarFreakClassFilesBuffer == null) {
            jarFreakClassFilesBuffer = new LinkedList();
            try {
                JarFile jar = new JarFile(jarfile);
                Enumeration<JarEntry> zipfile = jar.entries();
                while (zipfile.hasMoreElements()) {
                    String filename = ((Object)zipfile.nextElement()).toString();
                    if (filename.length() <= 6 || !filename.startsWith("freak/") || !filename.endsWith(".class")) continue;
                    jarFreakClassFilesBuffer.add(filename.substring(0, filename.length() - 6).replace('/', '.'));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return jarFreakClassFilesBuffer;
    }

    private static void addClassesInJARFile(String jarfile, String prefix, Collection classes, Class lookFor, boolean recursive) {
        Collection jarContent = ClassCollector.getJarFreakModuleClassnames(jarfile);
        for (String classname : jarContent) {
            String nameWithoutPath;
            if (classname.length() <= prefix.length() || !classname.startsWith(prefix, 0) || classname.startsWith("freak.gui")) continue;
            boolean filematch = recursive;
            if (!recursive && (nameWithoutPath = classname.substring(prefix.length())).indexOf(46) == -1) {
                filematch = true;
            }
            if (!filematch) continue;
            try {
                Class<?> c = Class.forName(classname);
                if (!lookFor.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
                classes.add(c);
            }
            catch (ClassNotFoundException e) {
                System.err.println("The class " + classname + " couldn't be found.!");
                e.printStackTrace();
            }
        }
    }

    private static void addClassesInFolder(File folder, String prefix, Collection classes, Class lookFor, boolean recursive) {
        File[] files = recursive ? folder.listFiles(new FolderClassFileFilter()) : folder.listFiles(new ClassFileFilter());
        int i = 0;
        while (i < files.length) {
            String s;
            if (files[i].isDirectory()) {
                s = String.valueOf(prefix) + files[i].getName() + ".";
                ClassCollector.addClassesInFolder(files[i], s, classes, lookFor, recursive);
            } else {
                s = files[i].getName();
                s = s.substring(0, s.length() - 6);
                try {
                    Class<?> c = Class.forName(String.valueOf(prefix) + s);
                    if (lookFor.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers())) {
                        classes.add(c);
                    }
                }
                catch (ClassNotFoundException e) {
                    System.err.println("The class " + files[i].getName() + " couldn't be found.!");
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    Collection getClasses(String folder, Class lookFor, boolean recursive) {
        Vector classes = new Vector();
        String prefix = "freak.module." + folder + ".";
        String[] classpaths = ClassCollector.getClassPaths();
        if (ClassCollector.getStartedFrom().toLowerCase().endsWith(".jar")) {
            ClassCollector.addClassesInJARFile(ClassCollector.getStartedFrom(), prefix, classes, lookFor, recursive);
            String resDir = String.valueOf(ClassCollector.getStartedFrom().substring(0, ClassCollector.getStartedFrom().lastIndexOf("/") + 1)) + "resource";
            classpaths = new String[]{resDir};
        }
        int cp = 0;
        while (cp < classpaths.length) {
            String folderName;
            File moduleFolder = new File(String.valueOf(classpaths[cp]) + "/freak/module");
            File inspectedFolder = new File(moduleFolder, folderName = folder.replace('.', '/'));
            if (inspectedFolder.exists()) {
                ClassCollector.addClassesInFolder(inspectedFolder, prefix, classes, lookFor, recursive);
            }
            ++cp;
        }
        return classes;
    }

    private SortedMap getGroupedOperatorClassesInJARFile(SearchSpace searchspace, String jarfile) {
        Collection classnames = ClassCollector.getJarFreakModuleClassnames(jarfile);
        String searchspaceString = searchspace.getClass().getName();
        searchspaceString = searchspaceString.substring(searchspaceString.lastIndexOf(".") + 1).toLowerCase();
        Pattern searchspacePattern = Pattern.compile("freak\\.module\\.operator\\.[a-z]*\\." + searchspaceString + "\\.[a-zA-Z\\.]*");
        Pattern commonPattern = Pattern.compile("freak\\.module\\.operator\\.[a-z]*\\.common\\.[a-zA-Z\\.]*");
        Pattern miscPattern = Pattern.compile("freak\\.module\\.operator\\.[a-z]*\\.[a-zA-Z]*");
        TreeMap groups = new TreeMap();
        for (String classname : classnames) {
            if (!searchspacePattern.matcher(classname).matches() && !commonPattern.matcher(classname).matches() && !miscPattern.matcher(classname).matches()) continue;
            String operatorType = classname.substring(22, classname.indexOf(46, 22));
            try {
                Class<?> c = Class.forName(classname);
                this.addOperatorToGroups(c, groups, operatorType);
            }
            catch (ClassNotFoundException e) {
                System.err.println("The class " + classname + " couldn't be found!");
                e.printStackTrace();
            }
        }
        return groups;
    }

    private void addOperatorToGroups(Class c, SortedMap groups, String key) {
        if (Operator.class.isAssignableFrom(c) && !Modifier.isAbstract(c.getModifiers())) {
            if (!groups.containsKey(key)) {
                groups.put(key, new LinkedList());
            }
            List list = (List)groups.get(key);
            list.add(c);
        }
    }

    SortedMap getGroupedOperatorClasses(SearchSpace searchspace) {
        String[] classpaths = ClassCollector.getClassPaths();
        if (ClassCollector.getStartedFrom().toLowerCase().endsWith(".jar")) {
            return this.getGroupedOperatorClassesInJARFile(searchspace, ClassCollector.getStartedFrom());
        }
        TreeMap groups = new TreeMap();
        int cp = 0;
        while (cp < classpaths.length) {
            File moduleFolder = new File(String.valueOf(classpaths[cp]) + "/freak/module");
            File inspectedFolder = new File(moduleFolder, "operator");
            if (inspectedFolder.exists() && inspectedFolder.isDirectory()) {
                File[] files = inspectedFolder.listFiles(new FolderFileFilter());
                int i = 0;
                while (i < files.length) {
                    File opFolder = new File(inspectedFolder, files[i].getName());
                    if (opFolder.exists() && opFolder.isDirectory()) {
                        LinkedList classes = new LinkedList();
                        ClassCollector.addClassesInFolder(opFolder, "freak.module.operator." + files[i].getName() + ".", classes, Operator.class, false);
                        File commonFolder = new File(opFolder, "common");
                        if (commonFolder.exists() && commonFolder.isDirectory()) {
                            ClassCollector.addClassesInFolder(commonFolder, "freak.module.operator." + files[i].getName() + ".common.", classes, Operator.class, true);
                        }
                        String searchspaceString = searchspace.getClass().getName();
                        File searchspaceFolder = new File(opFolder, searchspaceString = searchspaceString.substring(searchspaceString.lastIndexOf(".") + 1).toLowerCase());
                        if (searchspaceFolder.exists() && searchspaceFolder.isDirectory()) {
                            ClassCollector.addClassesInFolder(searchspaceFolder, "freak.module.operator." + files[i].getName() + "." + searchspaceString + ".", classes, Operator.class, true);
                        }
                        Iterator iter = classes.iterator();
                        while (iter.hasNext()) {
                            this.addOperatorToGroups((Class)iter.next(), groups, files[i].getName());
                        }
                    }
                    ++i;
                }
            }
            ++cp;
        }
        return groups;
    }

    public static Class[] getAllImplementors(Class lookFor) {
        Vector classes = new Vector();
        String[] classpaths = ClassCollector.getClassPaths();
        if (ClassCollector.getStartedFrom().toLowerCase().endsWith(".jar")) {
            ClassCollector.addClassesInJARFile(ClassCollector.getStartedFrom(), "freak.", classes, lookFor, true);
            String resDir = String.valueOf(ClassCollector.getStartedFrom().substring(0, ClassCollector.getStartedFrom().lastIndexOf("/") + 1)) + "resource";
            classpaths = new String[]{resDir};
        }
        int cp = 0;
        while (cp < classpaths.length) {
            File freakFolder = new File(String.valueOf(classpaths[cp]) + "/freak");
            String prefix = "freak.";
            if (freakFolder.exists()) {
                ClassCollector.addClassesInFolder(freakFolder, prefix, classes, lookFor, true);
            }
            ++cp;
        }
        Class[] result = new Class[classes.size()];
        int i = 0;
        while (i < classes.size()) {
            result[i] = (Class)classes.elementAt(i);
            ++i;
        }
        return result;
    }

    public static String getStartedFrom() {
        if (startedFrom == null) {
            try {
                Class<Freak> qc = Freak.class;
                CodeSource source = qc.getProtectionDomain().getCodeSource();
                if (source != null) {
                    startedFrom = source.getLocation().toURI().toString().substring(5);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return startedFrom;
    }

    public static class ClassFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".class");
        }
    }

    public static class FolderClassFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            return pathname.getAbsolutePath().endsWith(".class");
        }
    }

    public class FolderFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

