/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.AbstractDistribution;
import cern.jet.random.Fun;
import cern.jet.stat.Probability;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class StudentT
extends AbstractContinousDistribution {
    protected double freedom;
    protected double TERM;
    protected static StudentT shared = new StudentT(1.0, AbstractDistribution.makeDefaultGenerator());

    public StudentT(double freedom, RandomElement randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(freedom);
    }

    public double cdf(double x) {
        return Probability.studentT(this.freedom, x);
    }

    public double nextDouble() {
        return this.nextDouble(this.freedom);
    }

    public double nextDouble(double degreesOfFreedom) {
        double v;
        double u;
        double w;
        if (degreesOfFreedom <= 0.0) {
            throw new IllegalArgumentException();
        }
        while ((w = (u = 2.0 * this.randomGenerator.raw() - 1.0) * u + (v = 2.0 * this.randomGenerator.raw() - 1.0) * v) > 1.0) {
        }
        return u * Math.sqrt(degreesOfFreedom * (Math.exp(-2.0 / degreesOfFreedom * Math.log(w)) - 1.0) / w);
    }

    public double pdf(double x) {
        return this.TERM * Math.pow(1.0 + x * x / this.freedom, -(this.freedom + 1.0) * 0.5);
    }

    public void setState(double freedom) {
        if (freedom <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.freedom = freedom;
        double val = Fun.logGamma((freedom + 1.0) / 2.0) - Fun.logGamma(freedom / 2.0);
        this.TERM = Math.exp(val) / Math.sqrt(Math.PI * freedom);
    }

    public static double staticNextDouble(double freedom) {
        StudentT studentT = shared;
        synchronized (studentT) {
            return shared.nextDouble(freedom);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.freedom + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomGenerator) {
        StudentT studentT = shared;
        synchronized (studentT) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

