/*
 * Decompiled with CFR 0.152.
 */
package freak.module.stoppingcriterion;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.event.GenerationEvent;
import freak.core.stoppingcriterion.AbstractGenerationStoppingCriterion;

public class Random
extends AbstractGenerationStoppingCriterion {
    private double probability = 1.0E-4;

    public Random(Schedule schedule) {
        super(schedule);
    }

    public String getName() {
        return "Random";
    }

    public String getDescription() {
        return "With a specified probability it stops a run after the new generation event.";
    }

    public void checkCriterion(GenerationEvent evt) {
        RandomElement re = this.getSchedule().getRandomElement();
        if (re.raw() <= this.probability) {
            this.stopRun();
        }
    }

    public void setPropertyProbabilitytoStop(Double prob) {
        if (prob >= 0.0 && prob <= 1.0) {
            this.probability = prob;
        }
    }

    public Double getPropertyProbabilitytoStop() {
        return new Double(this.probability);
    }

    public String getShortDescriptionForProbabilitytoStop() {
        return "Probability";
    }

    public String getLongDescriptionForProbabilitytoStop() {
        return "Probability to stop at every check.";
    }
}

