/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.mutation.common;

import cern.jet.random.Poisson;
import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.Mutation;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.searchspace.SearchSpace;
import freak.module.searchspace.Cycle;
import freak.module.searchspace.Permutation;

public abstract class PoissonOperation
extends Mutation
implements Configurable,
CompatibleWithDifferentSearchSpaces {
    private double lambda = 1.0;

    public PoissonOperation(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        SearchSpace searchspace = schedule.getGenotypeSearchSpace();
        if (!(searchspace instanceof Permutation) && !(searchspace instanceof Cycle)) {
            throw new UnsupportedEnvironmentException("Wrong searchspace");
        }
    }

    public void setPropertyLambda(Double lambda) {
        this.lambda = lambda;
    }

    public Double getPropertyLambda() {
        return new Double(this.lambda);
    }

    public String getLongDescriptionForLambda() {
        return "The number of local operations is poisson distributed to this parameter.";
    }

    protected Individual doMutation(Individual ind) {
        RandomElement re = this.graph.getSchedule().getRandomElement();
        Poisson p = new Poisson(this.lambda, re);
        int count = p.nextInt() + 1;
        int i = 0;
        while (i < count) {
            ind = this.performSingleMutation(ind);
            ++i;
        }
        return ind;
    }

    protected abstract Individual performSingleMutation(Individual var1);
}

