/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset.util;

import freak.module.fitness.pointset.util.InvalidNthElementException;
import freak.module.fitness.pointset.util.MedianComputation;
import freak.module.fitness.pointset.util.QuickSelect;
import freak.module.fitness.pointset.util.WMedianElement;

class WeightedMedianComputation
extends MedianComputation {
    QuickSelect<WMedianElement> myQS = new QuickSelect();

    WeightedMedianComputation() {
    }

    private long sumWeights(WMedianElement[] array, int i_start, int i_end) {
        long sum = 0L;
        int i = i_start;
        while (i < i_end) {
            sum += (long)array[i].getWeight();
            ++i;
        }
        return sum;
    }

    private double weightedMedianRecursive(WMedianElement[] array, int i_start, int i_end, long Wl, long Wr, double W) {
        int n = i_end - i_start;
        try {
            this.myQS.quickSelectNthSmallestElement(array, n / 2, i_start, i_end);
        }
        catch (InvalidNthElementException e) {
            e.printStackTrace();
        }
        double m = array[i_start + n / 2].getValue();
        int i_left_start = i_start;
        int i_left_end = i_start + n / 2;
        int i_right_start = i_start + n / 2 + 1;
        int i_right_end = i_end;
        long weightsOfSmaller = this.sumWeights(array, i_left_start, i_left_end);
        long weightsOfBigger = this.sumWeights(array, i_right_start, i_right_end);
        if ((double)(weightsOfSmaller + Wl) <= W && (double)(weightsOfBigger + Wr) <= W) {
            return m;
        }
        if ((double)(weightsOfSmaller + Wl) <= W) {
            return this.weightedMedianRecursive(array, i_right_start, i_right_end, Wl += weightsOfSmaller + (long)array[i_start + n / 2].getWeight(), Wr, W);
        }
        return this.weightedMedianRecursive(array, i_left_start, i_left_end, Wl, Wr += weightsOfBigger + (long)array[i_start + n / 2].getWeight(), W);
    }

    public double weightedMedian(WMedianElement[] array) {
        double W = 0.5 * (double)this.sumWeights(array, 0, array.length);
        return this.weightedMedianRecursive(array, 0, array.length, 0L, 0L, W);
    }
}

