/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.runframe;

import freak.core.observer.Observer;
import freak.core.view.View;
import java.awt.BorderLayout;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

class FreakInternalFrame
extends JInternalFrame
implements Comparable {
    public static final int DEFAULT_WIDTH = 400;
    public static final int DEFAULT_HEIGHT = 400;
    private View view;
    private int viewId;

    FreakInternalFrame() {
        super("", true, true, true, true);
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(1);
        this.setSize(400, 400);
    }

    public int getViewId() {
        return this.viewId;
    }

    void setView(Observer observer, View view) {
        this.view = view;
        this.setTitle(String.valueOf(observer.getName()) + " - " + view.getName());
        this.setPanel(view.createPanel());
        this.viewId = view.getIdentificationNumber();
    }

    View getView() {
        return this.view;
    }

    private void setPanel(JPanel panel) {
        this.getContentPane().removeAll();
        this.getContentPane().add(panel);
        this.revalidate();
    }

    public int compareTo(Object o) {
        if (!(o instanceof FreakInternalFrame)) {
            return 0;
        }
        int diff = this.getViewId() - ((FreakInternalFrame)o).getViewId();
        return diff == 0 ? 0 : (diff < 0 ? -1 : 1);
    }
}

