/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.view.HistoryView;
import freak.core.view.swingsupport.FreakScrollBarAdjustmentListener;
import freak.core.view.swingsupport.FreakTextAreaModel;
import freak.core.view.swingsupport.SlidingWindow;
import freak.core.view.swingsupport.UpdateManager;
import freak.module.observer.ResultObserver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.lang.reflect.Array;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class StdView
extends HistoryView {
    private FreakTextAreaModel model = new FreakTextAreaModel();
    private SlidingWindow stringLengths = new SlidingWindow();
    private StringBuffer stringBuffer = new StringBuffer();

    public StdView(Schedule schedule) {
        super(schedule);
        this.numberOfDisplayedValues = 1;
    }

    public JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JTextArea text = new JTextArea(){

            public void scrollRectToVisible(Rectangle R) {
            }
        };
        text.setEditable(false);
        this.model.setView(text);
        JScrollPane scrollPane = new JScrollPane(text);
        JScrollBar scrollBar = scrollPane.getVerticalScrollBar();
        scrollBar.addAdjustmentListener(new FreakScrollBarAdjustmentListener(scrollBar, true));
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    public String getName() {
        return "Standard View";
    }

    public String getDescription() {
        return "Displays textual data in a frame.";
    }

    public Class[] getInputDataTypes() {
        return new Class[]{Object.class};
    }

    protected String extractTextFromObject(Object o) {
        if (o.getClass().isArray()) {
            StringBuffer s = new StringBuffer();
            int i = 0;
            while (i < Array.getLength(o)) {
                if (i > 0) {
                    s.append(", ");
                }
                Object element = Array.get(o, i);
                s.append(this.extractTextFromObject(element));
                ++i;
            }
            return s.toString();
        }
        return o.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setText(String text) {
        FreakTextAreaModel freakTextAreaModel = this.model;
        synchronized (freakTextAreaModel) {
            this.model.setText(text);
        }
        UpdateManager.markDirty(this.model);
    }

    public void update(Object o) {
        super.update(o);
        String newText = String.valueOf(this.extractTextFromObject(o)) + "\n";
        this.stringLengths.add(new Integer(newText.length()));
        this.stringBuffer.append(newText);
        if (this.numberOfDisplayedValues != 0 && !(this.getObserver() instanceof ResultObserver)) {
            while (this.stringLengths.size() > this.numberOfDisplayedValues) {
                int length = (Integer)this.stringLengths.get(0);
                this.stringBuffer.delete(0, length);
                this.stringLengths.removeFirst();
            }
        }
        this.setText(this.stringBuffer.toString());
    }
}

