/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.mutation.generalstring;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.searchspace.HasDimension;
import freak.core.searchspace.SearchSpace;
import freak.module.fitness.generalstring.IsingModelCliques;
import freak.module.operator.mutation.common.StandardMutation;
import freak.module.searchspace.GeneralString;
import freak.module.searchspace.GeneralStringGenotype;

public class OptimizedCliqueEA
extends StandardMutation {
    private int[][] flippedBits;
    private int numberOfFlippedBits;

    public OptimizedCliqueEA(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        SearchSpace searchspace = schedule.getGenotypeSearchSpace();
        if (!(searchspace instanceof GeneralString)) {
            throw new UnsupportedEnvironmentException("Wrong searchspace");
        }
        if (!(this.graph.getSchedule().getRealFitnessFunction() instanceof IsingModelCliques)) {
            throw new UnsupportedEnvironmentException("Does only work with the fitness IsingModelCliques");
        }
    }

    public String getDescription() {
        return "A highly optimized (1+1)EA for the Ising model on cliques.";
    }

    public String getName() {
        return "Optimized Ising Cliques (1+1)EA";
    }

    protected Individual doMutation(Individual ind) {
        int dimension = ((HasDimension)((Object)this.graph.getSchedule().getGenotypeSearchSpace())).getDimension();
        int numChars = ((GeneralString)this.graph.getSchedule().getGenotypeSearchSpace()).getNumChars();
        int startindex = 0;
        int nextPos = this.getNextPosition(dimension - 1);
        double fitnessDifference = 0.0;
        GeneralStringGenotype gt = (GeneralStringGenotype)ind.getGenotype();
        int[] genotype = gt.getIntArray();
        if (this.flippedBits == null || this.flippedBits.length != dimension) {
            this.flippedBits = new int[dimension][2];
        }
        this.numberOfFlippedBits = 0;
        RandomElement re = this.graph.getSchedule().getRandomElement();
        while (nextPos != -1) {
            int indexToFlip = startindex + nextPos;
            int oldValue = genotype[indexToFlip];
            int newValue = re.choose(0, numChars - 2);
            if (newValue == oldValue) {
                newValue = numChars - 1;
            }
            this.flippedBits[this.numberOfFlippedBits][0] = indexToFlip;
            this.flippedBits[this.numberOfFlippedBits][1] = newValue;
            ++this.numberOfFlippedBits;
            int[] adjacentNodes = ((IsingModelCliques)this.graph.getSchedule().getRealFitnessFunction()).getAdjacencyList(indexToFlip);
            int numberOfNodesWithOldValue = 0;
            int numberOfNodesWithNewValue = 0;
            int i = 0;
            while (i < adjacentNodes.length) {
                int colorOfNeighbor = genotype[adjacentNodes[i]];
                int j = 0;
                while (j < this.numberOfFlippedBits - 1) {
                    if (this.flippedBits[j][0] == adjacentNodes[i]) {
                        colorOfNeighbor = this.flippedBits[j][1];
                    }
                    ++j;
                }
                if (colorOfNeighbor == oldValue) {
                    ++numberOfNodesWithOldValue;
                }
                if (colorOfNeighbor == newValue) {
                    ++numberOfNodesWithNewValue;
                }
                ++i;
            }
            fitnessDifference += (double)(numberOfNodesWithNewValue - numberOfNodesWithOldValue);
            nextPos = this.getNextPosition(dimension - (startindex += nextPos + 1) - 1);
        }
        if (fitnessDifference >= 0.0) {
            GeneralStringGenotype newGenotype = (GeneralStringGenotype)gt.clone();
            int i = 0;
            while (i < this.numberOfFlippedBits) {
                newGenotype.set(this.flippedBits[i][0], this.flippedBits[i][1]);
                ++i;
            }
            double oldFitness = ((IsingModelCliques)this.graph.getSchedule().getRealFitnessFunction()).evaluate(ind, null);
            Individual result = new Individual(this.graph.getSchedule(), newGenotype, new Individual[]{ind});
            result.setLatestKnownFitnessValue(new Double[]{new Double(oldFitness + fitnessDifference)});
            return result;
        }
        return ind;
    }
}

