/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.runframe;

import freak.core.control.FreakFile;
import freak.gui.runframe.AbstractRunFrame;
import freak.gui.runframe.SingleExtensionFileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JFileChooser;

public class LoadSaveManager {
    private static SingleExtensionFileFilter filter = new SingleExtensionFileFilter(".freak", "Freak Schedule");
    private AbstractRunFrame parent;
    private File lastFile;
    private boolean lastFileLegal;

    public LoadSaveManager(AbstractRunFrame parent) {
        this.parent = parent;
    }

    public void newObject() {
        this.lastFileLegal = false;
    }

    public FreakFile load() {
        File f;
        JFileChooser c = new JFileChooser();
        c.setFileFilter(filter);
        int accepted = c.showOpenDialog(this.parent);
        if (accepted != 0) {
            return null;
        }
        this.lastFile = f = c.getSelectedFile();
        this.lastFileLegal = true;
        return this.doLoad();
    }

    public void save(FreakFile data) {
        if (this.lastFileLegal) {
            this.doSave(data);
        } else {
            this.saveAs(data);
        }
    }

    public void saveAs(FreakFile data) {
        JFileChooser c = new JFileChooser();
        c.setFileFilter(filter);
        int accepted = c.showSaveDialog(this.parent);
        if (accepted != 0) {
            return;
        }
        File f = c.getSelectedFile();
        this.lastFile = filter.fixExtension(f);
        this.lastFileLegal = true;
        this.doSave(data);
    }

    private FreakFile doLoad() {
        try {
            return FreakFile.read(new FileInputStream(this.lastFile));
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    private void doSave(FreakFile data) {
        try {
            data.write(new FileOutputStream(this.lastFile));
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }
}

