/*
 * Decompiled with CFR 0.152.
 */
package freak.core.view;

import freak.core.control.Schedule;
import freak.core.modulesupport.AbstractModule;
import freak.core.observer.Observer;
import freak.core.view.ObserverUnknownException;
import freak.core.view.View;

public abstract class AbstractView
extends AbstractModule
implements View {
    private Observer observer;
    private int identificationNumber;
    private int updateCounter;

    public AbstractView(Schedule schedule) {
        super(schedule);
        this.identificationNumber = schedule.getObserverManager().getIdentificationNumber();
        this.updateCounter = 0;
    }

    public int getIdentificationNumber() {
        return this.identificationNumber;
    }

    public Observer getObserver() {
        return this.observer;
    }

    public void setObserver(Observer observer) {
        this.observer = observer;
    }

    protected int getCurrentValue() throws ObserverUnknownException {
        if (this.getObserver() == null) {
            throw new ObserverUnknownException("Observer for " + this + " is unknown.");
        }
        switch (this.getObserver().getMeasure()) {
            case 1: {
                return this.getSchedule().getCurrentGeneration();
            }
            case 2: {
                return this.getSchedule().getCurrentTimeIndex().run;
            }
            case 3: {
                return this.getSchedule().getCurrentTimeIndex().batch;
            }
        }
        return this.updateCounter;
    }

    public void update(Object data) {
        ++this.updateCounter;
    }
}

