/*
 * Decompiled with CFR 0.152.
 */
package freak.module.populationmanager;

import freak.core.control.Schedule;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.graph.GraphException;
import freak.core.graph.Initialization;
import freak.core.graph.OutputLengthMismatchException;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.NoSuchIndividualException;
import freak.core.population.Population;
import freak.core.populationmanager.AbstractPopulationManager;
import freak.module.operator.selection.FitnessProportionalSelection;
import java.util.Iterator;

public class IslandModel
extends AbstractPopulationManager
implements Configurable {
    private int subpopulationcount = 2;
    private int migrantsCount = 0;
    private int epochLength = 10;
    private FitnessProportionalSelection selection;
    private boolean copyMigrants = true;
    private IndividualList[] populations;

    public IslandModel(Schedule schedule) {
        super(schedule);
    }

    public void initialize() {
        super.initialize();
        this.selection = new FitnessProportionalSelection(this.getSchedule().getOperatorGraph());
        this.selection.setPropertyNoOfIndividualsToSelect(new Integer(this.migrantsCount));
        this.selection.setPropertyUnique(new Boolean(true));
        this.selection.initialize();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (this.selection != null) {
            this.selection.testSchedule(schedule);
        }
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
    }

    private Population mergeSubpopulations(IndividualList[] p) {
        Population result = new Population(this.getSchedule());
        int i = 0;
        while (i < p.length) {
            result.addAllIndividuals(p[i]);
            ++i;
        }
        return result;
    }

    public void initPopulation(Initialization initialization) throws GraphException {
        this.populations = new Population[this.subpopulationcount];
        int i = 0;
        while (i < this.subpopulationcount) {
            this.populations[i] = new Population(this.getSchedule());
            ++i;
        }
        if (initialization == null) {
            throw new NullPointerException("Specified initialization operator is null.");
        }
        IndividualList[] resultOfInitialization = initialization.process(new IndividualList[0]);
        if (resultOfInitialization == null || resultOfInitialization.length == 0) {
            throw new OutputLengthMismatchException("Output of initialization operator is missing.");
        }
        Iterator it = resultOfInitialization[0].iterator();
        int j = 0;
        while (it.hasNext()) {
            this.populations[j % this.subpopulationcount].addIndividual((Individual)it.next());
            ++j;
        }
        this.setPopulation(this.mergeSubpopulations(this.populations));
        this.fireIndividualList(this.getPopulation());
    }

    public void createNewGeneration() throws GraphException, NoSuchIndividualException {
        if (this.populations[0].isEmpty()) {
            throw new NoSuchIndividualException("Population is empty.");
        }
        int i = 0;
        while (i < this.subpopulationcount) {
            this.populations[i] = this.getSchedule().getOperatorGraph().process(this.populations[i]);
            ++i;
        }
        if (this.getSchedule().getCurrentGeneration() % this.epochLength == this.epochLength - 1 && this.migrantsCount > 0) {
            i = 0;
            while (i < this.subpopulationcount) {
                this.populations[i] = (IndividualList)this.populations[i].clone();
                ++i;
            }
            IndividualList[] migrants = new IndividualList[this.subpopulationcount];
            int i2 = 0;
            while (i2 < this.subpopulationcount) {
                migrants[i2] = this.selection.process(new IndividualList[]{this.populations[i2]})[0];
                if (!this.copyMigrants) {
                    int j = 0;
                    while (j < migrants[i2].size()) {
                        this.populations[i2].removeIndividual(this.populations[i2].indexOf(migrants[i2].getIndividual(j)));
                        ++j;
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.subpopulationcount) {
                this.populations[i2].addAllIndividuals(migrants[(i2 + 1) % this.subpopulationcount]);
                ++i2;
            }
            if (this.copyMigrants) {
                this.selection.setPropertyInvert(new Boolean(true));
                int i3 = 0;
                while (i3 < this.subpopulationcount) {
                    IndividualList todelete = this.selection.process(new IndividualList[]{this.populations[i3]})[0];
                    int j = 0;
                    while (j < todelete.size()) {
                        this.populations[i3].removeIndividual(this.populations[i3].indexOf(todelete.getIndividual(j)));
                        ++j;
                    }
                    ++i3;
                }
                this.selection.setPropertyInvert(new Boolean(false));
            }
        }
        this.setPopulation(this.mergeSubpopulations(this.populations));
        this.fireIndividualList(this.getPopulation());
    }

    public String getDescription() {
        return "Implements multiple subpopulations. Each subpolution has isolated evolution. After an epoch individuals will migrate between the subpolutions.";
    }

    public String getName() {
        return "Island Model";
    }

    public void setPropertySubpopulationCount(Integer count) {
        if (count > 1) {
            this.subpopulationcount = count;
        }
    }

    public Integer getPropertySubpopulationCount() {
        return new Integer(this.subpopulationcount);
    }

    public String getShortDescriptionForSubpopulationCount() {
        return "Subpopulations";
    }

    public String getLongDescriptionForSubpopulationCount() {
        return "The number of subpopulations. The initialization population will be split to all subpopulations.";
    }

    public void setPropertyMigrantsCount(Integer count) {
        if (count >= 0) {
            this.migrantsCount = count;
        }
        this.selection.setPropertyNoOfIndividualsToSelect(count);
    }

    public Integer getPropertyMigrantsCount() {
        return new Integer(this.migrantsCount);
    }

    public String getShortDescriptionForMigrantsCount() {
        return "Number of migrants";
    }

    public String getLongDescriptionForMigrantsCount() {
        return "Determines how many fitness proportional selected individuals will migrate between two subpopulations every epoch.";
    }

    public void setPropertyEpochLength(Integer length) {
        if (length > 0) {
            this.epochLength = length;
        }
    }

    public Integer getPropertyEpochLength() {
        return new Integer(this.epochLength);
    }

    public String getShortDescriptionForEpochLength() {
        return "Epoch length";
    }

    public String getLongDescriptionForEpochLength() {
        return "The number of generations an epoch takes. After every epoch, communication between the islands will progress.";
    }

    public void setPropertyCopyMigrants(Boolean value) {
        this.copyMigrants = value;
    }

    public Boolean getPropertyCopyMigrants() {
        return new Boolean(this.copyMigrants);
    }

    public String getShortDescriptionForCopyMigrants() {
        return "Copy migrants";
    }

    public String getLongDescriptionForCopyMigrants() {
        return "If checked, after every epoch the individuals will copied, not moved to another subpopulation. After that the subpopulations will reduce its size to the original size by deleting negativ fitness proportional selected individuals.";
    }
}

